/**
 * @author Saket.Puranik
 
 * This component is used for to show Calendar Details Grid
 */
Ext.define('Academia.view.calendar.CalendarGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.calendargrid',
			/* requires : [ ], */
			store : 'calendar.CalendarStore',
			title : 'Calendar',
			collapsible:false,
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			columns : [/*{
				dataIndex :'id',
				hidden : true
			},*/{
				header : "Calendar Code",	
				dataIndex : 'code',
				align: 'center',
				sortable : true,	
			    flex : .2
			}, {
				header : "Calendar Name",
				dataIndex : 'name',
				align: 'center',
				sortable : true,	
				flex : .4
			}, {
				header : "Calendar Description",
				dataIndex : 'description',
				align: 'center',
				sortable : true,	
				flex : .4
			}, {
				header : "Status",
				dataIndex : 'status',
				align: 'center',
				sortable : true,	
				flex : .2

			}/*{
				header : "Used By ",
				dataIndex : '',	
				sortable : false,	
				flex : .4
			}, {
				header : "View",
				dataIndex : '',	
				sortable : false,	
				flex : .4
			},{
				dataIndex :'weekStart',
				hidden : true
			},{
				dataIndex :'weeklyOffs',
				hidden : true
			},{
				dataIndex: 'calendarWorkingWeekDays',
				hidden : true
			},{
				dataIndex :'version',
				hidden : true
			}*/],
			tbar : [ {
				xtype : 'button',				
				itemId : 'btnAddCalendar',
				tooltip : getCommonTranslation('ADD'),
				glyph: ICONGLYPH.ADDGLYPH
				//text : getCommonTranslation('ADD')
			},{
				xtype : 'button',				
				itemId : 'btnEditCalendar',
				tooltip : getCommonTranslation('EDIT'),//Edit department
				glyph: ICONGLYPH.EDITGLYPH
				//text : getCommonTranslation('EDIT')
			},{
				xtype : 'button',				
				itemId : 'btnViewCalendar',
				tooltip : getCommonTranslation('VIEW'),//View department
				iconCls: 'view-icon'
				//text : getCommonTranslation('VIEW')
			},{
				xtype : 'button',				
				itemId : 'btnDeleteCalendar',
				cls: 'CustomToolbarBtnReject',
				tooltip :'Delete department',
				glyph: ICONGLYPH.DELETEGLYPH
				//text : getCommonTranslation('DELETE')
			},{
				xtype : 'splitbutton',
				itemId:'spBtnMoreActions',
				text : getCommonTranslation('MOREACTIONS'),//More Actions
				menu:[{
					text:getCommonTranslation('ENTITY_LIST'),//ENTITY LIST
					itemId:'entityListMenu'
				},{
					text:getCommonTranslation('MAP_ACADEMY_LOCATIONS'),
					itemId:'mapAcademyLocationsLink'
				}],
				listeners: {
					click: function() {
						this.showMenu();
					}
				}
			}],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'calendar.CalendarStore',
					emptyMsg : "No topics to display",
					displayInfo : true
				} ]
			} ]
		});
