/**
 * @author Saket.Puranik
 
 * This component is used for to show Faculty details.
 */
Ext.define('Academia.view.calendar.entitylist.CourseVariantsGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.coursevariantsgrid',
			/* requires : [ ], */
			store : 'calendar.entitylist.CourseVariantsStore',
			title : getCommonTranslation('COURSE_VARIANT_TITLE'),//Course Variants
			collapsible:false,
			border: true,
			autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
			columns : [ {
				header : getCommonTranslation('COURSE_NAME'),//Course Name	
				dataIndex : 'courseVariantDescription',
				sortable : false,	
			    flex : .1
			}],
						
			tbar : [
		{
			xtype : 'textfield',
			itemId : 'courseVariantId',
			name : 'courseVariantName',
			emptyText:'--Course Name--'
		}
			        ],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'calendar.entitylist.CourseVariantsStore',
					emptyMsg :'<span id="courseVarGridId" style="margin-top: 60px !important">'+getCommonTranslation('EMPTY_COURSE_VARIANT_MESSAGE')+'</span>',//No Courses to display
					displayInfo : true
				} ]
			},{
				 xtype : 'toolbar',
				 dock : 'top',
				 items : [ {  xtype: 'label',
					 text: getCommonTranslation('CALENDAR_COURSES_GRID_TITLE'),
					 style: 'font-weight:bold;'} ]
			 } ]
		});
