/**
 * @author Saket.Puranik
 
 * This component is used for to show Equipment details.
 */
Ext.define('Academia.view.calendar.entitylist.EquipmentGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.equipmentsgrid',
			/* requires : [ ], */
			store : 'calendar.entitylist.EquipmentStore',
			title : getCommonTranslation('EQUIPMENT_TITLE'),//Facililties
			collapsible:false,
			border: true,
		    //autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
			columns : [ {
				header : getCommonTranslation('EQUIPMENT_CODE_HEADER'),//Facililty Code	
				dataIndex : 'code',
				align: 'center',
				sortable : false,	
			    flex : .2
			}, {
				header : getCommonTranslation('EQUIPMENT_NAME_HEADER'),//Facililty Name
				dataIndex : 'name',
				align: 'center',
				sortable : false,	
				flex : .4
			}, {
				header : getCommonTranslation('EQUIPMENT_TYPE_HEADER'),//Resource Type
				dataIndex : 'type',	
				align: 'center',
				sortable : false,	
				flex : .4
			}, {
				header : getCommonTranslation('EQUIPMENT_STATUS_HEADER'),//Status
				dataIndex : 'status',	
				align: 'center',
				sortable : false,	
				flex : .2			
			}],
						
			tbar : [{
	        	xtype:'customcombobox',
	        	store:'calendar.entitylist.filters.ResourceTypeFilterStore',
	        	displayField:'value',
	        	valueField:'id',
	        	itemId:'comboResourceType',
	    		editable:false,
	        	emptyText:'All Resource Types'	
	        }],
			dockedItems : [  {
				xtype : 'toolbar',
				dock : 'top',
				items : [ {  xtype: 'label',
			        text: getCommonTranslation('CALENDAR_EQUIPMENT_GRID_TITLE'),
			        style: 'font-weight:bold;'} ]
			},{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'calendar.entitylist.EquipmentStore',
					emptyMsg : '<span id="ALPurposeGridId" style="margin-top: 60px !important">'+getCommonTranslation('EMPTY_EQUIPMENT_MESSAGE')+'</span>',//No faculty to display
					displayInfo : true
				} ]
			} ]
		});
