/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.campaign.CampaignsStructureGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.campaignsStructureGrid',
    store: 'campaign.CampaignsStructureStore',
    title: getCommonTranslation('TITLE_LIST_OF_CAMPAIGN'),
    border: true,
    id: 'capaignstructuregrid_gridId',
    autoScroll: true,
    viewConfig: {
        stripeRows: false
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            store: 'campaign.CampaignsStructureStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE')
        }]
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnCmpAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnCmpEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnCmpView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnCmpDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        hidden: true,
        dataIndex: 'id'
    }, {
        header: getCommonTranslation('CAMPAIGN_CODE'),
        dataIndex: 'code'
    }, {
        header: getCommonTranslation('CAMPAIGN_NAME'),
        dataIndex: 'campaignName',
        sortable: true
    }, {
        header: getCommonTranslation('BUDGET_AMOUNT'),
        dataIndex: 'budgetAmount',
        sortable: true
    }, {
        header: getCommonTranslation('ACTUAL_AMOUNT'),
        dataIndex: 'actualAmount',
        sortable: true
    }, {
        header: getCommonTranslation('ACADEMY_NAME'),
        dataIndex: 'campaignCoverages',
        flex: 1,
        renderer: function(vals) { // to render multiple academy for single campaign row
            var academy = '';
            Ext.each(vals, function(academyVal) {
                var aId = '<li>' + academyVal.academy.value + '<br>' + '<br>';
                academy = academy + aId;
            });
            return academy;
        }
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION_NAME'),
        dataIndex: 'campaignCoverages',
        flex: 1,
        renderer: function(vals) { // to render multiple locations for single campaign row
            var location = '';
            Ext.each(vals, function(locationVal) {
                var lId = '<li>' + locationVal.location.value + '<br>' + '<br>';
                location = location + lId;
            });
            return location;
        }
    }, {
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'campaignCoverages',
        flex: 1,
        renderer: function(vals) { // to render multiple programs for single campaign row
            var program = '';
            Ext.each(vals, function(programVal) {
                var pId = '<li>' + programVal.program.value + '<br>' + '<br>';
                program = program + pId;
            });
            return program;
        }
    }, {
        header: getCommonTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        sortable: true,
        type: 'Date',
        renderer: function(date) { // to render a data as user defined format
            return dateRender(date);
        }
    }, {
        header: getCommonTranslation('TO_DATE'),
        dataIndex: 'toDate',
        sortable: true,
        type: 'Date',
        renderer: function(date) { // to render a data as user defined format
            return dateRender(date);
        }
    }, {
        header: getCommonTranslation('REMARKS'),
        dataIndex: 'remarks'
    }, {
        header: getCommonTranslation('DESCRIPTION'),
        dataIndex: 'campaignDesc'
    }]
});