/* @author Amit G */
Ext.define('Academia.view.campaign.dashboard.ActiveCampaignDashboardGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCampaignTranslation('ACTIVE_CAMPAIGNS'),
	alias : 'widget.activecampaigndashboardgrid',
	store: 'campaign.ActiveCampaignDashboardStore',
	border: true,
	refreshStoreData:true,
	frame: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store:'campaign.ActiveCampaignDashboardStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	tbar: ['->',{
		xtype: 'button',
		itemId: 'exportCampaignReport',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
	}],
	columns : [  {
		header : getCommonTranslation('CAMPAIGN_ID'),
		dataIndex : 'campaignId',
		flex : .2
	}, {
		header : getCommonTranslation('CAMPAIGN_CODE'),
		dataIndex : 'campaignCode',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	}, {
		header : getCommonTranslation('CAMPAIGN_NAME'),
		dataIndex : 'campaignName',
		flex : .2
	}, {
		header : getCommonTranslation('NO_OF_DAY_ACTIVE'),
		dataIndex : 'noOfDayActive',
		flex : .2
	}, {
		header : getCommonTranslation('TOTAL_ENQUIRY'),
		dataIndex : 'totalEnquiry',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	}, {
		header : getCommonTranslation('NO_OF_APPLICATIONS'),
		dataIndex : 'noOfApplications',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	},{
		header : getCommonTranslation('STUDENT_ENROLLED'),
		dataIndex : 'studentAdmitted',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	},{
		header : getCommonTranslation('PROGRAMS_COVERED'),
		dataIndex : 'programsCovered',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	},{
		header : getCommonTranslation('CONTACT_PERSON'),
		dataIndex : 'contactPerson',
		flex : .2
	},{
		header : getCommonTranslation('TOTAL_DURATION'),
		dataIndex : 'totalDuration',
		flex : .2
	},{
		header : getCommonTranslation('ACTUAL_COST_OF_CAMPAIGN'),
		dataIndex : 'costCampaign',
		flex : .2
	},{
		header : getCommonTranslation('ACADEMIES_COVERED'),
		dataIndex : 'academiesCovered',
		flex : .2,
		renderer : function(value) {
			return '<a href="#">' + value + '</a>';
		}
	},{
		header : getCommonTranslation('LOCATIONS_COVERED'),
		dataIndex : 'locationsCovered',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	},{
		header : getCommonTranslation('STUDENT_SELECTED'),
		dataIndex : 'studentSelected',
		flex : .2,
		renderer : function(value) {
			if(value !='0'){
				return '<a href="#">' + value + '</a>';
			}else{
				return  value;
			}
		}
	},{
		header : getCommonTranslation('CREATED_BY'),
		dataIndex : 'createdBy',
		flex : .2
	},{
		header : getCommonTranslation('ACTUAL_AMOUNT'),
		dataIndex : 'costPerAdmission',
		flex : .2
	}		    
	]

});
