/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.committee.committee.CommitteeFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.committeefilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype : 'radiogroup',
		itemId: 'committeeRadioGrp',
		name:'manageCommittee',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
    		margin:'0 5 0 5'
		},
		items:[{ 
			boxLabel: getServiceRequestTranslation('ALL_COMMITTEE'), 
			name: 'manageCommittee', 
			inputValue: 'ALL_COMMITTEE',
			itemId: 'allCommittee',
			checked:true,
            margin: '0 5 0 0'
		},{ 
			boxLabel: getServiceRequestTranslation('MY_COMMITTEE'), 
			name: 'manageCommittee',
			itemId: 'myCommittee',
			inputValue: 'MY_COMMITTEE'
		},{
			boxLabel: 'Alumni', 
			name: 'manageCommittee',
			itemId: 'alumniCommitteeItemId',
			inputValue: 'ALUMNI_COMMITTEE'
		}],
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'committee',
			itemId:'committeeItemId',
			store:'committee.committee.CommitteeStore',
			displayField:'valueCode',
			valueField:'id',
			queryParam:'name',
			typeAhead:false,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME"),
			hidden: false
		},{
			xtype: 'customcombobox',
            name: 'committeeAlumni',
            itemId: 'committeeItemIdAlumni',
            store: 'committee.committee.AlumniCommitteeStore',
            displayField: 'valueCode',
            valueField: 'id',
            queryParam: 'name',
            minChars: 3,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection: true,
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
            fieldLabel: getCommonTranslation("COMMITTEE_CODE_NAME"),
            hidden: true 
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("ACADEMY_LOCATION"),
			name: 'ACADEMY_LOCATION_ID',
			itemId:'academyLocationCombo',
			editable: true,
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			name: 'committeeType',
			itemId: 'committeeTypeItemId',
			fieldLabel: getCommonTranslation("COMMITTEE_TYPE"),
			valueField: 'id',
			displayField: 'value',
			store:Ext.create('Academia.store.committee.committee.UserWiseCommitteeType'), 
  			editable: false,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
  			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width:226,
			labelAlign: 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'userType',
			itemId: 'userType',
			fieldLabel: getFileManagementTranslation('USER_TYPE'),
			editable: false,
			disableKeyFilter: false,
			valueField: 'id',
			displayField: 'userGroupName',
			store: 'attendance.UserGroup'
			
		},{
			xtype: 'customcombobox',
			name:'assignedUser',
			itemId:'assignedUser',
			fieldLabel : getFileManagementTranslation('USER'),
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
					combo.bindStore(store)
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			store:'common.StatusComboStore',
			displayField:'name',
			valueField:'id',
			value:'ACTIVE',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('STATUS'),
			/*listeners: {
				render: function(object) {
					object.getStore().load({
						callback:function(record) {
							object.setValue(record[0].data.id);
						}
					});
				}
			}*/
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
