/**
 * This is the Academy Location Program Batch SeatType Dependent Dropdown Component.
 * 
 * This component will be used for selection of the Academy Location Program Batch SeatType
 * based on the selection of the previous dropdowns value.
 * 
 * use the "xtype: acadlocprogbatchseattypecomponent" to integrate it in any screen.<br>
 * user checkUserAccess==true for loading data according to user right
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.common.AcadLocProgBatchSeattypeComponent', {
    extend: 'Ext.form.Panel',
    alias: 'widget.acadlocprogbatchseattypecomponent',
    loadDefaultAcadLocation : false,
    allowBlankSelection: false,
	cls : 'panelNoSpace',
	overridetSubmitData: true,
	getArrayValue: false,
	/* style: {
		marginTop: '0px',
	//	marginBottom: '10px',
		//marginLeft: '10px'
	},*/
	initComponent:function(){
		 this.items= [{
		        xtype: 'fieldcontainer',
		        layout: {
		            type: 'vbox'
		        },
		        itemId:'mainFldCon',
		        items: [{
		        	xtype: 'fieldcontainer',
		        	layout: 'hbox',
		        	style:{
		        		marginTop:'2px !important'
		        	},
		        	defaults: {
		        		xtype: 'nestedJsonCombo',
		        		overridetSubmitData :  this.overridetSubmitData,
		        		getArrayValue :  this.getArrayValue,
		        		queryMode: 'local',
		        		autoload: false,
		        		allowBlank: this.allowBlankSelection,
		        		width: 150,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		name: 'academy',
		        		itemId: 'academyCombo',
		        		displayField: 'value',
		        		valueField: 'id',
		        		queryMode: 'remote',
		        		fieldLabel: getCommonTranslation('ACADEMY'),
		        		listeners: {
		        			select: function(combo, records, eOpts) {
		        				this.nextSibling().setDisabled(false);
		        				this.up('#mainFldCon').loadDependentCombo(this.nextSibling(), records, 'academyId');
		        			},
		        			render: function(combo) {
		        				var storeUrl='Academia.store.common.AcademyStore';
		        				if(this.up('form').checkUserAccess==true){
		        					storeUrl='Academia.store.common.AcademyByUserStore';
		        				}
		        				var store = Ext.create(storeUrl);
		        				combo.bindStore(store);
		        			}
		        		}
		        	}, {
		        		name: 'location',
		        		itemId: 'locationCombo',
		        		displayField: 'value',
		        		valueField: 'id',
		        		disabled : true,
		        		fieldLabel: getCommonTranslation('LOCATION'),
		        		listeners: {
		        			select: function(combo, records, eOpts) {
		        				var academyId = this.previousSibling().getValue();
		        				var programCombo = this.up('#mainFldCon').down('#programCombo');
		        				programCombo.setDisabled(false);
		        				//this.nextSibling().setDisabled(false);
		        				this.up('#mainFldCon').loadDependentCombo(programCombo, records, 'locationId', 'academyId', academyId);
		        			},
		        			render: function(combo) {
		        				var storeUrl='Academia.store.common.LocationStore';
		        				if(this.up('form').checkUserAccess==true){
		        					storeUrl='Academia.store.common.LocationByUserStore';
		        				}
		        				var store = Ext.create(storeUrl);
		        				combo.bindStore(store);
		        			}
		        		}
		        	}]
		        },{
		        	xtype: 'fieldcontainer',
		        	layout: 'hbox',
		        	style:{
		        		marginTop:'6px !important'
		        	},
		        	defaults: {
		        		xtype: 'nestedJsonCombo',
		        		overridetSubmitData :  this.overridetSubmitData,
		        		getArrayValue :  this.getArrayValue,
		        		queryMode: 'local',
		        		autoload: false,
		        		allowBlank: this.allowBlankSelection,
		        		width: 150,
		        		labelAlign: 'top'
		        	},
		        	items: [{
			            name: 'program',
			            itemId: 'programCombo',
			            displayField: 'value',
			            valueField: 'id',
			            disabled : true,
			            fieldLabel: getCommonTranslation('PROGRAM'),
			            listeners: {
			                select: function(combo, records, eOpts) {
			                	this.nextSibling().setDisabled(false);
			                    this.up('#mainFldCon').loadDependentCombo(this.nextSibling(), records, 'id');
			                },
			                render: function(combo) {
			                    var storeUrl='Academia.store.common.ProgramsByAcademyIdLocationId';
				              	  if(this.up('form').checkUserAccess==true){
				              		  storeUrl='Academia.store.common.ProgramsByAcademyIdLocationIdAndUser';
				              	  }
				              	  var store = Ext.create(storeUrl);
			                    combo.bindStore(store);
			                    
			                }
			            }
			        }, {
			            name: 'batch',
			            itemId: 'batchCombo',
			            displayField: 'value',
			            valueField: 'id',
			            disabled : true,
			            fieldLabel: getCommonTranslation('BATCH'),
			            listeners: {
			                select: function(combo, records, eOpts) {
			                	this.nextSibling().setDisabled(false);
			                    this.up('#mainFldCon').loadDependentCombo(this.nextSibling(), records, 'batchId');
			                },
			                render: function(combo) {
			                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
			                    combo.bindStore(store);
			                }
			            }
			        }, {
			            name: 'seatType',
			            itemId: 'seatTypeCombo',
			            displayField: 'seatTypeName',
			            valueField: 'seatTypeId',
			            disabled : true,
			            progBatchSeatConfigId: null,
			            fieldLabel: getCommonTranslation('SEAT_TYPE'),
			            listeners: {
			            	select: function(combo, records, eOpts) {
			            		combo.progBatchSeatConfigId =records[0].get('id');
			            	},
			            	render: function(combo) {
			                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
			                    combo.bindStore(store);
			                }
			            }
			        }]
		        }],

		        /**
		         * Method to load the next combo based on the selection of the previous combo value.
		         * @param {Object} dependentCombo is the reference of the next dropdown which should be populated with values.
		         * @param {Object} selectedRecord is the record of the previous dropdown which is selected.
		         * @param {Object} parameter is the value that should be attached in the url.
		         * @param {Object} extraParameter (optional) If there is any extra parameter to be sent for loading the
		         *  dependent dropdown.
		         * @param {Object} extraParamValue (optional) The value of the extraParam that is sent for loading the store.
		         */
		        loadDependentCombo: function(dependentCombo, selectedRecord, parameter, extraParameter, extraParamValue) {
		        	
		        	  var id = selectedRecord[0].get('id');
		        	  
		        	this.loadDependentComboById(dependentCombo, id, parameter, extraParameter, extraParamValue) ;
		        }, 
		        
		        loadDependentComboById: function(dependentCombo, id, parameter, extraParameter, extraParamValue) {
		        	
		      	this.resetOtherDropdowns(dependentCombo);
		          dependentCombo.clearValue();
		          dependentCombo.store.removeAll();
		          var store = dependentCombo.getStore();
		        
		          var url = store.getProxy().proxyConfig.api.read;
		          if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
		              url = url.concat('?' + parameter + '=' + id);
		          } else {
		              url = url.concat('?' + parameter + '=' + id);
		              url = url.concat('&' + extraParameter + '=' + extraParamValue);
		          }
		          store.getProxy().api.read = url;
		          store.reload();
		      }, 
		        /**
		         * code to reset other dropdowns based on the selection of any dropdown which is previous in the hierarchy.
		         * eg: if all the dropdowns are loaded and the Academy is changed then subsequent dropdowns should be
		         * changed accordingly, so their value is cleared and reset and reloaded.
		         * @param: {Object} combo The reference of the dropdown which is the dependent/next combo. 
		         */
		        resetOtherDropdowns: function(combo) {
		        	var container = combo.up('#mainFldCon');
		        	switch(combo.name) {
		        	case 'academy':
		        		break;
		        	case 'location':
		        		this.clearCombo(combo);
		        		programCombo = container.down('combo[name=program]');
		        		this.clearCombo(programCombo);
		        		batchCombo = container.down('combo[name=batch]');
		        		this.clearCombo(batchCombo);
		        		seatTypeCombo = container.down('combo[name=seatType]');
		        		this.clearCombo(seatTypeCombo);
		        		break;
		        	case 'program':
		        		this.clearCombo(combo);
		        		batchCombo = container.down('combo[name=batch]');
		        		this.clearCombo(batchCombo);
		        		seatTypeCombo = container.down('combo[name=seatType]');
		        		this.clearCombo(seatTypeCombo);
		        		break;
		        	case 'batch':
		        		this.clearCombo(combo);
		        		seatTypeCombo = container.down('combo[name=seatType]');
		        		this.clearCombo(seatTypeCombo);
		        		break;
		        	case 'seatType':
		        		this.clearCombo(combo);
		        		break;
		        	}
				},
				
				/**
				 * function to clear the combo store, clear its existing value
				 *  and remove all the records from the store.
				 *  @param {Object} the reference of the combo whose store should be cleared.
				 */
				clearCombo: function(combo) {
					combo.clearValue();
		    		combo.store.removeAll();
					}
			}];

	        this.callParent(arguments);
	},
	reset:function(){
		var academyCombo =this.down('combo[name=academy]');
		academyCombo.reset();
		var locationCombo =this.down('combo[name=location]');
		this.items.items[0].resetOtherDropdowns(locationCombo);
		locationCombo.reset();
		var programCombo =this.down('combo[name=program]');
		var batchCombo =this.down('combo[name=batch]');
		var seatCombo =this.down('combo[name=seatType]');
		locationCombo.setDisabled(true);
		programCombo.setDisabled(true);
		batchCombo.setDisabled(true);
		seatCombo.setDisabled(true);
		programCombo.reset();
		batchCombo.reset();
		seatCombo.reset();
	},
	
    listeners: {
        afterrender: function(combo) {
        	
        	if(this.loadDefaultAcadLocation){
        		
        	var acadLocId =  Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getValue();
        	  var this$= this;
        	  Ext.Ajax.request({
                  type: 'rest',
                  url: SERVERURL.FIND_ACADEMY_LOCATION_IDS,
                  method: 'GET',
                  headers: {
                      'Content-Type': 'application/json'
                  },
                  params :{id: acadLocId },
                  success: function(response) {
                  	data = Ext.decode(response.responseText);
              		
              	  var acadCombo =combo.down('#academyCombo');
              	  acadCombo.getStore().load({
              		  callback : function(){
              			  acadCombo.setValue(data.academyId);
              			  this$.items.items[0].loadDependentComboById(acadCombo.nextSibling(), data.academyId, 'academyId');
              		  }
              	  });
              	
              		var locCombo =combo.down('#locationCombo');
                	  locCombo.getStore().load({
                		  callback : function(records){
                			  Ext.each(records,function(items){
              		  			if(items.data.id === data.locationId){
              		  				locCombo.setValue(data.locationId);
              		  			}
              		  		});
                			  this$.items.items[0].loadDependentComboById(locCombo.nextSibling(),data.locationId,'locationId', 'academyId', data.academyId);
                		  }
                	  });
              	
                  }
                  
              });
        	}  
        }
    }
});