/**
 * This form is used to display checklist of pending items.
 * @author Pritam.Patil
 */
Ext.define('Academia.view.completion.setup.ShowChekListPopUp', {
    extend: 'Ext.window.Window',
    alias: 'widget.showcheklistpopup',
    border : false,
    frame : false,
    modal: true,
    width:'20%',
    height:'40%',
    items: [{
    	  xtype: 'dataview',
          itemId: 'checkListItemId',
          store: Ext.create('Ext.data.Store', {
          	fields: ['student','mobileNumber','email','program','effectiveDate','pendingDocuments','returnDocuments',
          	         'issueCertificates','enrolled_in','totalPendingPayments','totalRefundPayments'],
              data:[]
          }),
          itemSelector: 'div.thumb-wrap1',
          tpl:  new Ext.XTemplate( 
        		'<tpl for=".">',
        		'<div class="thumb-wrap1">', 
        		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
    			'<tr>', 
    			'<td style="width:40%;vertical-align:top;">', 
    				'<table class="no-spacing" cellspacing="0" cellpadding="7" border="0" style="width:100%">',
    					'<tr>',
    						'<td>',
	        						'<tr>', 
	        							'<td> <span style="font-weight:bold; color:black;">' + getCompletionModuleTranslation('PENDING_DOCUMENTS') + '</span></td>',
	        							'<td> <span style="font-weight:bold; color:blue;">'+': {pendingDocuments} </span></td>', 
	        						'</tr>', 
		        					'<tr>', 
		        						'<td> <span style="font-weight:bold; color:black;">' + getCompletionModuleTranslation('ISSUE_CERTIFICATES') + '</span></td>',
		        						'<td> <span style="font-weight:bold; color:blue;">'+': {issueCertificates} </span></td>', 
		        					'</tr>',
		        					'<tr>', 
		        						'<td> <span style="font-weight:bold; color:black;">' + getCompletionModuleTranslation('RETURNABLE_DOCUMENTS') + '</span></td>',
		        						'<td> <span style="font-weight:bold; color:blue;">'+': {returnDocuments} </span></td>', 
	        					    '</tr>',
	        					    '<tr>', 
		        						'<td> <span style="font-weight:bold; color:black;">' + getCompletionModuleTranslation('TOTAL_PENDING_PAYMENTS') + '</span></td>',
		        						'<td> <span style="font-weight:bold; color:blue;">'+': {totalPendingPayments} </span></td>', 
		        				    '</tr>',
		        				    '<tr>', 
		        						'<td> <span style="font-weight:bold; color:black;">' + getCompletionModuleTranslation('TOTAL_REFUND_PAYMENTS') + '</span></td>',
		        						'<td> <span style="font-weight:bold; color:blue;">'+': {totalRefundPayments} </span></td>', 
	        				    '</tr>',
    						'</td>',
    					'</tr>',
    				'</table>', 
    			'</td>', 
    			'</div>',
	    '</tpl>')
    }]
    
});