/**
 * @author Ankur Jaiswal
 * 
 */
Ext.define('Academia.view.configureloader.ConfigureLoaderFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.configureloaderfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226,
        },
        items: [{
            xtype: 'customcombobox',
            name: 'terminology',
            itemId: 'terminologyItemId',
            fieldLabel: getCommonTranslation('TERMINOLOGY'),
            store: 'common.TerminologyStore',
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            name: 'loaderTypeId',
            itemId: 'loaderTypeItemId',
            store: 'importutility.LoaderConfiguredModuleNameStore',
            fieldLabel: getCommonTranslation('CL_LOADER_TYPE'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
            allowBlank: false
        }, {
            xtype: 'label',
            itemId: 'viewLinkedItemId',
            html: '<a class="menu-title" style="display: block;float: left;width: 300px;text-decoration: underline;">' + getCommonTranslation('CL_VIEW_LINKED_ACADEMY_LOCATIONS') + '</a>',
            style: {
                textDecoration: "underline",
                'margin': '32px 0 0 0',
                'font-size': '16px',
                'cursor': 'pointer'
            }/*,
            width:300,
            listeners: {
            	afterrender: function( me, eOpts ){
            		me.setWidth(300);
            	}
            }*/
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchConfigureLoaderFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetConfigureLoaderFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});