/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.course.CourseMasterQuickFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.courseMasterQuickFilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
   layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype: 'customcombobox',
            	width:460,
                name: 'courseName',
                maxLength:308,
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//		        translationKey:'COURSE_CODE_NAME',
            	itemId:'courseNameQuickFiltr',
            	store:'coursetransaction.studymaterialdistribution.FindAllCoursesByAcademyLocation',
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'qry',
    			minChars:3,
    			allowBlank: true,
    			typeAhead:false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            }
            	}]
        	},
        	{
        		xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [{
        			xtype: 'customcombobox',
        			name: 'department',
        			itemId:'courseDepartment',
        			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
//    		        translationKey:'COURSE_DEPARTMENT',
        			store:'course.CourseDepartmentStore',
        			editable: true,
        			valueField: 'id',
        			displayField: 'value',
        			allowBlank: true,
        			queryMode:'local',
					typeAhead : false,
					forceSelection : true,
					anyMatch : true
        		},{
        			xtype : 'customcombobox',
        			name : 'courseMarkGrade',
        			itemId:'courseMarksGrades_id',
        			fieldLabel : getCommonTranslation('COURSE_MARK_GRADES'),	
//    		        translationKey:'COURSE_MARK_GRADES',
        			store:'course.CourseMarkGradeStore',
        			valueField : 'id',
        			displayField : 'value',
        			triggerAction : 'all',
        			editable : false,
        			allowBlank : true
        		}]
        	},
        	{
        		xtype:'fieldcontainer',
        		layout:'hbox',
        		width:'100%',
        		defaults: {
        			width: 226,
        			labelAlign: 'top'
        		},
        		items:[{
        			xtype : 'customcombobox',
        			name : 'sectionType',
        			itemId:'sectionType',
        			fieldLabel : getCommonTranslation('SECTION_TYPE'),		
//    		        translationKey:'SECTION_TYPE',
        			store:'course.SectionTypeStore',
        			valueField : 'id',
        			displayField : 'value',
        			triggerAction : 'all',
        			editable : false,
        			allowBlank : true
        		}]
        		},
        	{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
		            xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: 'right',
		            itemId:'whether_deleted',
		            boxLabel: getCommonTranslation('INCLUDE_DELETED_RECORDS'),
		            name: 'whetherIncludeDeeletedCourses',
		            inputValue : true,
		            uncheckedValue: false ,
		            style:{marginLeft:'1px'}
		        }]
        	}, {
            xtype: 'fieldcontainer',
            width: 'auto',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'courseQuickSearchId',
                ui: 'CustomBtnSubmit',
                margin:'0 0 0 0',
                scale: CONSTANTS.BUTTONSIZE
            },{
            	 xtype: 'button',
                 text: getCommonTranslation('RESET'),
                 itemId: 'courseQuickResetId',
                 ui: 'CustomBtnCancel',
                 scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});