/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.course.NoOfProgAssociatedGrid', {
	 extend: 'Ext.form.Panel',
	alias : 'widget.noofprogassociatedgrid',
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
		    store : 'course.NoOfProgAssociatedGridStore',
		    displayInfo : true
		} ]
	    }],
	items:[{
		xtype: 'grid',
		store : 'course.NoOfProgAssociatedGridStore',
		columns : [{
			header : 'ID',
			hidden : true,
			dataIndex:'id'
		},{
			header:  getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex: 'academyLocationName',
			flex: 1,
			sortable:true
		},{
			header : getCommonTranslation('PROGRAM_NAME'),
			dataIndex : 'programNameToBePrint',
			flex : 1	

		}, {
			header : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex : .5
		}]
	}]	
});
