/**z
 * @author dharmendra.p
 */

Ext.define('Academia.view.coursetracker.CourseTrackerChart' ,{
	extend: 'Ext.chart.Chart',
	alias : 'widget.coursetrackerchart',
	plain: true,
	autoScroll: false,
	requires: ['Ext.chart.*', 'Ext.layout.container.Fit', 'Ext.window.MessageBox'],
    animate: true,
    shadow: true,
    width: 1200,
    height: 500,
    layout: 'fit',
    legend: {
        position: 'bottom',
        boxStrokeWidth: 0,
        labelFont: '12px Helvetica'
    },
    store: 'coursetracker.CourseTrackerChart',
    axes: [{
    	title: getCommonTranslation('IN_MINUTES'),
        type: 'numeric',
        position: 'left',
        fields: 'planned',
        grid: true,
        minimum: 0
       /* label: {
            renderer: function(v) { 
            	console.log('VVVVVVVVVVVVVVVVVV',v);
            	return v; + '%'; 
            }
        }*/
    }, {
        type: 'category',
        position: 'bottom',
        fields: 'name',
        grid: true
        /*label: {
            rotate: {
                degrees: -45
            }
        }*/
    }],
    series: [{
        type: 'column',
        axis: 'left',
        title: [ getCommonTranslation('PLANNED'),getCommonTranslation('ACTUAL')],

        xField: 'name',
        yField: ['planned','actual'],
        gutter : 40,
        style: {
        	 width: 100,
        	 minGapWidth: 20
        	//backgroundColor: '#F0F8FF'
            //opacity: 0.80
        },
        /*highlight: {
            fill: '#000',
            'stroke-width': 1,
            stroke: '#000'
        },*/
        tips: {
            trackMouse: true,
            style: 'background: #FFF',
            width: 140,
            height: 28,
            renderer: function(storeItem, item) {
                var browser = item.series.title[Ext.Array.indexOf(item.series.yField, item.yField)];
                this.setTitle(browser + ' for ' + storeItem.get('name') + ': ' + storeItem.get(item.yField) + '%');
            }
        }
    }]
});
