/**
 * @author Dharmendra.Prajapati
 *
 * 
 */
Ext.define('Academia.view.coursetransaction.homework.submissiondetails.SubmissionDetails', {
    extend: 'Ext.window.Window',
    alias: 'widget.submissiondetails',
    modal: true,
    autoScroll:true,
    title: getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'),
    maxHeight:600,
    items: [{
        xtype: 'customfieldform',
        customFieldEntity:CONSTANTS.GROUP_HOMEWORK_ASSIGNMENT_CD,
        columns: 1,
        method: 'POST',
        defaults: {
            labelAlign: 'top',
            autoScroll:true,
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
        layout: 'vbox',
        items: [{
        	xtype:'fieldcontainer',
        	defaults: {
                labelAlign: 'top',
                width:226
            },
            layout : {
    			type : 'hbox'
    		},
        	items: [{  
        		xtype: 'hidden',
        		name: 'id'
        	},{  
        		xtype: 'hidden',
        		name: 'selectedAssignmentStatus',
        		itemId:'selectedAssignmentStatus'
        	},{
        		xtype: 'hidden',
        		name: 'studentHiddenId'
        	},{
        		xtype: 'customcombobox',
        		name: 'groupName',
        		hidden:true,
        		itemId:'groupName_Id',
        		readOnly:true,
        		fieldLabel:getCourseTxCommonTranslation('HW_GROUP_NAME') ,
        		store:'coursetransaction.homework.submissiondetails.GroupName',
        		displayField:'value',
        		valueField:'value'
        	},{
        		xtype: 'customcombobox',
        		name: 'studentId',
        		readOnly:false,
        		itemId:'studentName_Id',
        		fieldLabel:getCourseTxCommonTranslation('HW_STUDENT_NAME') ,
        		store:'coursetransaction.homework.submissiondetails.StudentName',
        		displayField:'value',
        		valueField:'id',
        		hidden:true
        	},{
        		xtype: 'customcombobox',
        		name: 'assignmentStatus',
        		readOnly:false,
        		itemId:'assignmentStatus_Id',
        		fieldLabel:getCourseTxCommonTranslation('HW_ASSIGNMENT_STATUS') ,
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		editable:false
        	},{
        		xtype: 'datefield',
        		fieldLabel: getCourseTxCommonTranslation('HW_SUBMISSION_DATE'),
        		allowBlank:false,
        		name: 'submissionDate',
        		itemId:'submissionDate',
        		maxValue:new Date(),
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		}
        	}]
        },{
        	xtype : 'radiogroup',
        	itemId:'isResubmissionRequired_id',
        	name: 'isResubmissionRequire_ID',
        	labelAlign : 'top',
        	allowBlank: true,
        	//hidden:true,
        	style:{marginTop:'5px'},
        	layout: 'hbox',
        	fieldLabel : getProgramandcourseTranslation('IS_RESUBMISSION_REQUIRED'),
        	items : [{
        		boxLabel : getCommonTranslation('YES'),
        		name:'isResubmissionRequire_ID',
        		inputValue : true,
        		width:70
        	},{
        		boxLabel : getCommonTranslation('NO'),
        		name:'isResubmissionRequire_ID',	
        		inputValue : false,
        		checked : true
        	}]
        },{
        	xtype:'fieldcontainer',
        	 layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width:226,
        	},
        	items: [{
        		xtype: 'datefield',
        		fieldLabel: getCourseTxCommonTranslation('RESUBMISSION_DUE_DATE'),
        		allowBlank:false,
        		width:226,
        		name: 'reSubmissionDueDate',
        		itemId:'reSubmissionDueDate',
        		minValue:new Date(),
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		}
        	
        	},{
        		xtype: 'datefield',
        		fieldLabel: getCourseTxCommonTranslation('Resubmission Date'),
        		name: 'reSubmissionDate',
        		itemId:'reSubmissionDate',
        		width:226,
        		//maxValue:new Date(),
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		}
        	}]
        },{
    	   xtype:'fieldcontainer',
    	   defaults: {
       		labelAlign: 'top',
       		width:226
       	},
       	style:{marginTop:'5px'},
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSubmit',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});