Ext.define('Academia.view.coursetransaction.managedistribution.CreateDistributionList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.createdistributionlist',
	store : 'coursetransaction.managedistributionlist.CreateDistributionListStore',
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'coursetransaction.managedistributionlist.CreateDistributionListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	columns : [{
		header :getCourseTxCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVarientName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('READING_NAME'),
		dataIndex : 'readingName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('DISTRIBUTOIN_MODE'),
		dataIndex : 'distributionMode',
		flex:1
	}]
});
