/**
 * @author Angad Yadav
 */
Ext.define('Academia.view.coursetransaction.promotion.ImportDemoteStatusUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.importDemoteStatusUploadForm',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items : [{
		xtype:'uploadoptionradiogroup',
		width: 300,
		margin: 0,
		itemId:'importDemoteStatusUploadOptionRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [{
			xtype: 'customcombobox',
			name:'importUtilityMasterId',
			itemId:'uploadTypeItemId',
			labelAlign: 'top',
			store: Ext.create('Academia.store.importutility.ModuleName'),
			fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			triggerAction : 'all',
			editable: false,
			maxLength: 40,
			width: 200
		}]
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 460,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
