var PromotionListStore = Ext.create('Academia.store.coursetransaction.promotion.PromotionList');
Ext.define('Academia.view.coursetransaction.promotion.PromotionList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.promotionlist',
	store: PromotionListStore,
	title: getProgramandcourseTranslation('PROMOTION_LIST'),
	border: true,
		cls: 'promotionlistGridCls',
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
			  itemId:'custompagingtoolbar',
	          plugins:['pagesize'],
			  store : PromotionListStore,
			  emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			  displayInfo : true
		} ]
	}
	],
	plugins: [
        {
      	  ptype : 'cellediting',
      	  clicksToEdit: 1
        }
        ],
	listeners:{
		beforeselect:function(selModel,record,index){
			if(!isNullOrEmpty(selModel.view.up())){
				var gridItemId = selModel.view.up().getItemId();
				if(record.get('promotionStatus') == 'Hold'){
					return false;
				}
			}
		},
		itemmouseenter: function(view, record, item) {
    		if(record.get('promotionStatus') == 'Hold'){
    			Ext.fly(item).set({'data-qtip': getProgramandcourseTranslation('STATUS_FOR_PROMOTION_CANNOT_BE_CHANGED_DUE_TO_NON_PAYMENT_OF_FEES')});
    		}
    	}         
	},
	tbar: [{
		xtype : 'button',
		text:getCommonTranslation('PROMOTE_RETAIN_DEMOTE'),
    	itemId:'promoteRetainId'
	},{
		xtype : 'button',
		text:getProgramandcourseTranslation('APPROVE'),
    	itemId:'approveId'
	},{
		xtype : 'button',
		text:getProgramandcourseTranslation('Save'),
    	itemId:'saveBtnId'
	},{
		xtype : 'button',
		text:getProgramandcourseTranslation('SEND_MESSAGE'),
    	itemId:'sendMessageId'
	}],
	columns : [{
		header : getProgramandcourseTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',		
		flex:1,
		renderer:function(value,meta,record){
			if(isNullOrEmpty(value)){
				return value;
			} else {
				return '<a href=#>'+value+'</a>'
			}
		}
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},{
		header : getCommonTranslation('PPROGRAM_COORDINATOR'),
		dataIndex : 'coordinatorName',
		flex : 1
	},{
		header :getCommonTranslation('EXTERNAL_REFERENCE_NUMBER1'),
		dataIndex : 'externalSysRefOne',
		hidden: true,
		flex:1
	},{
		header :getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTerm',
		hidden: true,
		flex:1
	},{
		header :getProgramandcourseTranslation('ADMISSION_CODE'),
		dataIndex : 'fromAdmissionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('PROGRAM'),
//	    translationKey: 'PROGRAM_FROM',
		dataIndex : 'fromProgramName',
		flex:1
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'fromBatchName',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'fromPeriodName',
		hidden: true,
		flex:1
	},{
		header : getProgramandcourseTranslation('SECTION'),
		dataIndex : 'fromSectionName',
		hidden: true,
		flex:1
	},{
		header :getProgramandcourseTranslation('TO_ADMISSION_CODE'),
		dataIndex : 'toAdmissionCode',
		hidden: true,
		flex:1
	},{
		header : getProgramandcourseTranslation('PROGRAM_TO'),
		dataIndex : 'toProgramName',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.promotionStatus) && (record.data.promotionStatus=="Pending" || record.data.promotionStatus=="PENDING"
				|| record.data.promotionStatus=="Pass Out Approval Pending")){
				return '';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('BATCH_TO'),
		dataIndex : 'toBatchName',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.promotionStatus) && (record.data.promotionStatus=="Pending" || record.data.promotionStatus=="PENDING"
				|| record.data.promotionStatus=="Pass Out Approval Pending")){
				return '';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('PERIOD_TO'),
		dataIndex : 'toPeriodName',
		hidden: true,
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.promotionStatus) && (record.data.promotionStatus=="Pending" || record.data.promotionStatus=="PENDING"
				|| record.data.promotionStatus=="Pass Out Approval Pending")){
				return '';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('SECTION_TO'),
		dataIndex : 'toSectionName',
		hidden: true,
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.promotionStatus) && (record.data.promotionStatus=="Pending" || record.data.promotionStatus=="PENDING"
				|| record.data.promotionStatus=="Pass Out Approval Pending")){
				return '';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('AUTHORIZED_BY'),
		dataIndex : 'approverName',
		hidden: true,
		flex:1
	},{
		header : getProgramandcourseTranslation('AUTHORIZED_DATE'),
		dataIndex : 'approvalDate',
		hidden: true,
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('EXAMINATION_STATUS'),
		dataIndex : 'examinationStatus',
		flex:1
	},{
		header : getProgramandcourseTranslation('PROMOTION_STATUS'),
		dataIndex : 'promotionStatus',
		flex:1,
		editor : {
			xtype: 'customcombobox',
			name:'promotionStatus_Name',
			store:'student.studentJourney.ProgressionStatusStoreForGrid',
			valueField : 'value',
			displayField : 'value',
			editable:false
		}
	},{
		header : getProgramandcourseTranslation('REMARKS'),
		dataIndex : 'remarks',
		flex:1
	},{
		header : getCommonTranslation('FAILURE_REASON'),
		dataIndex : 'failureReason',
		flex:1
	}]
});
