var sectionTeacherMappingStore = Ext.create('Academia.store.coursetransaction.sectionmanagement.CoruseVariantFacultyMappingGridStore');
Ext.define('Academia.view.coursetransaction.sectionmanagement.SectionTeacherMappingGrid', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.sectionteachermappinggrid',
    store : sectionTeacherMappingStore,
    title : getCommonTranslation('FACULTY_LIST'),
    border: true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
    }
    ],
    tbar: [{
		xtype : 'button',				
		itemId : 'facultyDeleteItemId',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns : [{
	    header :getCommonTranslation('PRIMARY_FACULTY_CODE') ,
	    dataIndex : 'primaryFacultyCodeValue',
	    flex : 1,
	    renderer : function(value,records) {
			if(!isNullOrEmpty(records.record.data.facultyCode) && !isNullOrEmpty(records.record.data.facultyName)){
				return records.record.data.facultyCode+"/"+records.record.data.facultyName;
			}
		}
	}, {
	    header : getCommonTranslation('ALTERNATE_FACULTY_CODE'),
	    dataIndex : 'alternatfacultyCodeValue',
	    flex : 1,
	    renderer : function(value,records) {
	    	if(!isNullOrEmpty(records.record.data.alternatFacultyCode) && !isNullOrEmpty(records.record.data.alternatfacultyName)){
				return records.record.data.alternatFacultyCode+"/"+records.record.data.alternatfacultyName;
			}
		}
	} 
	]

});
 
