
/*
 * @author Akshay Sharma
 */
var variantId;

Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.CoreErpStudentEnrollmentDetailGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'coursetransaction.studentenrollment.studentenrollmentdetail.AdminStudentCourseEnrollmentDetail',
	alias:'widget.coreerpstudentenrollmentdetailgrid',
	title: getProgramandcourseTranslation('STUDENT_COURSE_REGISTRATION'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable : true,
    enableColumnHide: true,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	header:{
        titlePosition: 0,
        items:[{
    		xtype : 'button',		
    		text:getCommonTranslation('INSTRUCTION_FOR_COURSE_REGISTRATION'),
    		itemId:'instructionForCourseRegistration',
    		hidden:true,
    		cls: 'linkBtnGridCls'
    	}]    
     },
	tbar: [{
		xtype : 'button',		
		text:getCommonTranslation('BULK_ENROLL'),
		itemId:'saveBulkEnrollmentDetailItemId',
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('ENROLL'),
		itemId:'saveEnrollmentDetailItemId',
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('UNENROLL'),
		itemId:'deEnrollmentCourseItemId',
		tooltip : getCommonTranslation('IT_WILL_KEEP_UNENROLLMENT_RECORDS'),
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('DEENROLL'),
		itemId:'deleteCourseEnrollmentDetailItemId',
		tooltip : getCommonTranslation('IT_WONT_KEEP_DEENROLLMENT_RECORDS'),
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('ADDITIONAL_COURSE'),
		itemId:'additionalCourseButton',
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('CHANGE_EXAM_CENTER'),
		itemId:'changeExamCenterButton',
		disabled:true
	},{
		xtype:'textfield',
		emptyText: getCommonTranslation('COURSE_CODE_COURSE_NAME'),
		//width: 220,
		name:'coreerpregistrationcoursegridsearch',
		itemId:'coreerpregistrationcoursegridsearch',
		cls: 'cstmCrsName ',
		emptyCls: 'search-empty-text-field cstmCrsName ',
		maxWidth:130
	},{
		xtype: 'tbspacer',
		flex:1
	},
{
		xtype : 'button',		
		text:getCommonTranslation('PROOF_OF_REGISTRATION'),
		itemId:'proofOfRegistrationBtn',
		disabled:true
	},{
		xtype : 'button',		
		text:getCommonTranslation('DOWNLOAD_ELIGIBILITY_SHEET'),
		itemId:'downloadEligibilitySheetId',
		disabled:true
	}],
	columns:[{
		header:getCourseTxCommonTranslation('SELECT'),
		dataIndex : 'sel',
		flex:.09,
		renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
			var approv=null;
			var request=null;
			var normal=null;
			for(var j=0;j<record.data.variantList.length;j++){

				var variant=record.data.variantList[j];
				if(variant.whetherApproved && variant.whetherRequested){
					approv=true;
				}else if(variant.whetherRequested){
					request=true;
				}else if(!variant.whetherRequested && !variant.whetherApproved && !variant.whetherRejected){
					normal=true;
				}
			}
			/*if(record.data.whetherRequested && record.store.data){
					record.store.data.items.forEach(function(newRec){
				        if( record.data.courseId == newRec.data.courseId && record.data.courseGroupId != newRec.data.courseGroupId && newRec.isHiddenCheck != true){
				             newRec.set('isHiddenCheck', true);
				        }
				});
			}*/
			if(record.data.isEnrolledInTransferCredit){
				return 	Ext.String.format("<input type='checkbox' name='rowSel' style='display:none;'/>");
			}
			if(record.data.isHiddenCheck){
				return 	Ext.String.format("<input type='checkbox' name='rowSel' style='display:none;'/>");
			}

			if(record.data.mustOptCourse){
				return 	Ext.String.format("<input type='checkbox' name='rowSel' checked=checked disabled/>");
			}

			if(record.data.whetherPassed){
				return 	Ext.String.format("<input type='checkbox' name='rowSel' checked=checked disabled/>");
			}

			if(approv){
				return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' checked=checked disabled/>");
			}else if(request){
				return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' checked=checked/>");
			}else if(normal){
				return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox'/>");
			}

		}
	},{
		header :getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex:'courseCode',
		flex:.2,
		sortable : true,
		renderer: function(value, e, rec){
			if(rec.data.isOfferedYearlyBadge == true){
				var yearlyDiv = '<span title="'+getCommonTranslation('YEARLY')+'" class="yearlyBadgeCls">Y</span>';
			}
			else{
				var yearlyDiv = '';
			}
			if(value.split("/").length > 1){
				var code = value.split("/")[0];
				var name = rec.data.courseName;
				
				return yearlyDiv+code+"/"+name;
			}
			return yearlyDiv+value;
		}
	},/*{
		header :getCommonTranslation('COURSE_NAME'),
		dataIndex:'courseName',
		flex:.2,
		sortable : true,
		hidden:true
	},*/{
		header :getCommonTranslation('COURSE_GROUP_NAME'),
		dataIndex:'courseGroupName',
		flex:.1,
		sortable : true,
		renderer:function(value, e, rec){
			if(!isNullOrEmpty(rec.data.courseGroupName)) {
				return rec.data.courseGroupName;
			}else{
				return "-";
			}
		}
	},{
		header:getCommonTranslation('COURSE_CODE'),
		dataIndex:'courseCodeNew',
		flex:.1
	},{
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex:'courseName',
		flex:.1,	
	},{
		header:getCourseTxCommonTranslation('TYPE'),
		dataIndex:'whetherOptional',
		flex:.1,
		renderer:function(val, metaData, record){
			if(!val){
				return getCourseTxCommonTranslation('MANDATORY');
			}else if(val){
				return getCourseTxCommonTranslation('OPTIONAL');
			}

		}
	},{
		header:getCommonTranslation('CREDITS'),
		//dataIndex:'credits',
		dataIndex:'parameterizedCredits',
		flex:.1
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex:'courseVariantId',
		flex:.1,
		editor : {
			xtype: 'customcombobox',
			name:'courseVariant_Name',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentCourseVariantDropDown',
			valueField : 'variantId',
			displayField : 'variantCode',
			forceSelection : true,
			editable : false,
			typeAhead:false,
			listeners:{
				select: function(combo){
					var grid = combo.up('grid');
					var store = grid.getStore();
					try{
						var record = grid.getSelectionModel().getSelection()[0];
						var recData = record.data;
						
						if(!recData.isHiddenCheck){
							var checkField = Ext.query('[data-recordid='+grid.getSelectionModel().getSelection()[0].internalId+']')[0].children[0].children[0].children[0];
							var getcontroller=Academia.app.getController('Academia.controller.coursetransaction.studentcourseenrollment.StudentEnrollmentDetailTabController');
							var tempStore=getcontroller.getStore('coursetransaction.studentenrollment.studentenrollmentdetail.TempStudentEnrollmentDetailData');
							tempStore.remove(record,true);
							checkField.setAttribute('checked','checked');
							checkField.checked = true;
							tempStore.loadRawData(record,true);
							
							var isCheckTrue = true;
							
							//-- not allowing user to select multiple record with same course id, different course group
							 Ext.each(store.data.items, function(currentStoreItem){
								 var currentStoreItemCourseId = currentStoreItem.data.courseId;
								 var currentStoreItemCourseGroupId =currentStoreItem.data.courseGroupId;
								 
								 if(!isNullOrEmpty(currentStoreItemCourseGroupId) && !isNullOrEmpty(recData.courseId) && !isNullOrEmpty(recData.courseGroupId) && recData.courseId == currentStoreItemCourseId && recData.courseGroupId != currentStoreItemCourseGroupId){
									 currentStoreItem.set('isHiddenCheck', isCheckTrue);
								 }
							 })
						}
						else{
							combo.reset();
							return false;
						}
						
					}
					catch(e){}
				}
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var grid = view;
			var $this= this;
			var store = grid.getStore();
			var models = grid.getStore().getRange();
			
			if(record.data.isEnrolledInTransferCredit == true){
				return "";
			}

			for(var j=0;j<record.data.variantList.length;j++){
				var variant=record.data.variantList[j];
				if(variant.whetherApproved && variant.whetherRequested){
					rec.tdCls = "comboboxdisable";
				}
			}
			if((val=='' || val== undefined)){
				var variantCode = record.data.variantCode;
				if(variantCode !='' && variantCode != null){
					return variantCode;
				} else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('SELECT_VARIANT');
				}
			} else if(val!='' && val!= undefined){
				var grid = view.up();
				var ddlRecord = grid.getMlpData();
				for (var i in ddlRecord) {
					if(Ext.isDefined(ddlRecord[i].data))
					{
						var ddlRecordNew = ddlRecord[i].data;
					}
					else
					{
						var ddlRecordNew = ddlRecord[i];
					}
					if(val == ddlRecordNew.variantId) {
						models[rowIndex].set("variantCode",""+ddlRecordNew.variantCode);
						models[rowIndex].set("courseVariantId",ddlRecordNew.variantId);
					}
				}
				return record.data.variantCode;
			} else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('SELECT_VARIANT');
			}	

		}
	},{
		header: getCommonTranslation('TIME_TABLE'),
		dataIndex:'timeTable',
		columnId:'timeTable',
		flex:.1,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			return '<a href="#">View</a>';
		}
	},{
		header:getCommonTranslation('SUBJECT_FEE_AMOUNT'),
		dataIndex:'moduleFee',
		hidden:true,
		flex:.1,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			return record.data.moduleFee;
		}
	},{
		header:getCourseTxCommonTranslation('VARIANT_DETAILS'),
		dataIndex:'variantDetail1',
		flex:.1,
		columnId:'viewVariantDetail',
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			return '<a href="#">View</a>';
		}
	},{
    	header:getCommonTranslation('EXAM_CENTER'),
    	dataIndex:'examCenterId',
    	flex:.1,
        editor : {
			xtype: 'customcombobox',
			itemId: 'examCenterId',
			name: 'examCenterId',
			store:Ext.create('Academia.store.enquiry.ExamCenterCSMStore'),
			valueField: 'id',
			displayField: 'value',
		    forceSelection:true,
		    editable : false,
		    typeAhead:false,
				listeners:{
					select: function(combo){
						var grid = combo.up('grid');
						try{
							var record = grid.getSelectionModel().getSelection()[0];
							var checkField = Ext.query('[data-recordid='+grid.getSelectionModel().getSelection()[0].internalId+']')[0].children[0].children[0].children[0];
							var getcontroller=Academia.app.getController('Academia.controller.coursetransaction.studentcourseenrollment.StudentEnrollmentDetailTabController');
							var tempStore= grid.gridTempStore;//getcontroller.getStore('coursetransaction.studentenrollment.studentenrollmentdetail.TempStudentEnrollmentDetailData');
							record.data.examCenterName = combo.getDisplayValue();
//							record.set('examCenterName',combo.getDisplayValue());
							tempStore.remove(record,true);
							checkField.setAttribute('checked','checked');
							checkField.checked = true;
							tempStore.loadRawData(record,true);
						}
						catch(e){}
					}
				}
        },renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(record.data.isEnrolledInTransferCredit == true){
        		return "";
        	}

        	var examCenterName = record.data.examCenterName;
        	for(var j=0;j<record.data.variantList.length;j++){
        		var variant=record.data.variantList[j];
        		if(record.data.examCenterId!=null&&variant.whetherApproved && variant.whetherRequested){
        			rec.tdCls = "comboboxdisable";
        		}else if(record.data.examCenterId==null && variant.whetherApproved && variant.whetherRequested){
        			rec.tdCls = "comboboxdisable";
        		}
        	}
        	if(examCenterName !='' && examCenterName != null){
        		return examCenterName;
        	} else {
        		rec.tdCls = 'gridInputCustomStyle'; 
        		for(var j=0;j<record.data.variantList.length;j++){
        			var variant=record.data.variantList[j];
        			if(record.data.examCenterId==null && variant.whetherApproved && variant.whetherRequested){
        				rec.tdCls = "comboboxdisable";
        				return getProgramandcourseTranslation('');
        			}
        		}
        		return getCommonTranslation('SELECT_EXAM_CENTER');
        	}


        }
    },{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:.09,
		sortable:true,
 	},{
		header:getCommonTranslation('COURSE_STATUS'),
		dataIndex:'courseStatus',
		flex:.1,
		sortable : true
	},{
		header: getCommonTranslation('ADDITIONAL_REQUISITE'),
		dataIndex: 'additionalRequisite',
		flex: .2,
		soratable: false,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			if(value){
				return '<a href="#">View</a>'; //preRequisiteJson, coRequisiteJson
			}
			else if(!isNullOrEmpty(record.raw.compulsorySet) && record.raw.compulsorySet.length){
				return '<a href="#">View</a>'; //corequisite
			}
			else if(!isNullOrEmpty(record.raw.preRequsitViewModels) && record.raw.preRequsitViewModels.length){
				return '<a href="#">View</a>'; //prereq
			}
		}
	},{
		header:getProgramandcourseTranslation('COURSE_ENROLLMENT_STATUS'),
		dataIndex:'courseEnrollmentStatus',
		flex:.1,
		sortable : true,
		renderer:function(value, metaData, record, rowIndex, colIndex, store, view){
			if(record.data.isEnrolledInTransferCredit){
				return  "Enrolled";
			}
			else{
				return value;
			}
		}
	}],
	plugins: [
	          {
	        	  ptype : 'cellediting',
	        	  clicksToEdit: 1
	          }
	          ],
	          listeners: {
	        	  beforeedit: function(obj, editor, context) {
	        		  var columnDataIndex = obj.context.field;
                      if ((columnDataIndex == "courseVariantId" || columnDataIndex == "examCenterId") && editor.record.data.isEnrolledInTransferCredit == true) {
                          return false;
                      } 
                      return true;
	              },
	        	  edit: function(obj, editor, context){
	        		  var this$= this;
	        		  var grid = obj.grid;
	        		  var storeGrid = grid.getStore();
	        		  var flag=true;
	        		  var models = grid.getStore().getRange();
	        		  for(var i =0; i<storeGrid.data.length;i++){
	        			  if(editor.rowIdx==i){
	        				  /*var mainStore = this$.getStore('coursetransaction.homework.CourseVarientByCourseIdDropDown');
        					 var store = mainStore;
        					 store.getProxy().extraParams = {
        						 courseId: store.data.items[i].data.courseId
        					 };
        					 store.load({
        						 callBack:function(record) {
        							 for(var j in record){
        					   				if(storeGrid.data.items[i].data.variantCode==record[j].data.id){*/
//	        				  models[i].set("malPracticeId",malPracticeData[j].data.id);
//	        				  models[i].set("courseVariantToPrint",'bhanu');
	        				  /*	}
        					   			}
        						 }
        					 });*/
	        			  }
	        		  }
	        	  }
	          },
	          renderTo: Ext.getBody()        
});


