/**
 * @author Akshay Sharma
 */

Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.DeEnrollCourseRegistration', {
	extend: 'Ext.window.Window',
	alias: 'widget.deenrollcourseregistration',
	modal : true,
	resizable:false,
	autoScroll: false,
	layout: 'fit',
	height: '80%',
	width: '80%',
	title:getCommonTranslation('UNENROLL'),
	items: [{
		xtype: 'grid',
		itemId : 'deenrollcourseregistration',
		store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetail2',
		frame: false,
		border:true,
		title:getCommonTranslation('DEENROLL'),
		autoScroll: true,
		flex:1,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
			ftype: 'summary',
			showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
		}],
		selType:'checkboxmodel',
		selModel: {
			mode:'MULTI',
			showHeaderCheckbox: false,
			allowDeselect: false,
			checkOnly : true
		},
		tbar: [{
			xtype : 'button',		
			text:getCommonTranslation('UNENROLL'),
			itemId:'unEnroll'
		},{
    		xtype : 'button',		
    		text:getCommonTranslation('DEENROLL'),
    		itemId:'deleteEnroll'
    	},{
			xtype:'displayfield',
			name : 'saveEnrollmentMsg',
			itemId : 'saveEnrollmentMsgId',
			hidden:true
		}],
		columns: [{
			header :getCommonTranslation('COURSE_CODE_NAME'),
			dataIndex:'courseCode',
			flex:.2,
			sortable : true
		},{
			header :getCommonTranslation('COURSE_NAME'),
			dataIndex:'courseName',
			flex:.2,
			sortable : true
		},{
			header:getCourseTxCommonTranslation('TYPE'),
			dataIndex:'whetherOptional',
			flex:.1,
			renderer:function(val, metaData, record){
				if(!val){
					return getCourseTxCommonTranslation('MANDATORY');
				}else if(val){
					return getCourseTxCommonTranslation('OPTIONAL');
				}

			}
		},{
			header:getCommonTranslation('CREDITS'),
			dataIndex:'parameterizedCredits',
			flex:.1
		},{
			header:getCommonTranslation('COURSE_VARIANT'),
			dataIndex:'courseVariantId',
			flex:.1,
			editor : {
				xtype: 'customcombobox',
				name:'courseVariant_Name',
				store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetail3',
				valueField : 'variantId',
				displayField : 'variantCode',
				typeAhead:false
			},
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				var grid = view;
				var $this= this;
				var store = grid.getStore();
				var models = grid.getStore().getRange();

				for(var j=0;j<record.data.variantList.length;j++){
					var variant=record.data.variantList[j];
					if(variant.whetherApproved && variant.whetherRequested){
						rec.tdCls = "comboboxdisable";
					}
				}
				if((val=='' || val== undefined)){
					var variantCode = record.data.variantCode;
					if(variantCode !='' && variantCode != null){
						return variantCode;
					} else {
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('SELECT_VARIANT');
					}
				} else if(val!='' && val!= undefined){
					var grid = view.up();
					var ddlRecord = grid.getMlpData();
					for (var i in ddlRecord) {
						if(val == ddlRecord[i].data.variantId) {
							models[rowIndex].set("variantCode",""+ddlRecord[i].data.variantCode);
							models[rowIndex].set("courseVariantId",ddlRecord[i].data.variantId);
						}
					}
					return record.data.variantCode;
				} else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('SELECT_VARIANT');
				}	

			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1
		}],
		listeners: {
			edit: function(obj, editor, context){
				var this$= this;
				var grid = obj.grid;
				var storeGrid = grid.getStore();
				var flag=true;
				var models = grid.getStore().getRange();
				for(var i =0; i<storeGrid.data.length;i++){
					if(editor.rowIdx==i){
						var mainStore = this$
						.getStore('coursetransaction.studentenrollment.studentenrollmentdetail.StudentPortalEnrollmentCourseVariantDropDown');
						var store = mainStore;
						store.getProxy().extraParams = {
							courseId: store.data.items[i].data.courseId
						};
						store.load({
							callBack:function(record) {
								for(var j in record){
									if(storeGrid.data.items[i].data.variantCode==record[j].data.id){
									}
								}
							}
						});
					}
				}
			}
		},
		renderTo: Ext.getBody()  	
	}]
});