/**
 * By Angad Yadav
 */
Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.TimeTableCourseRegistration', {
	extend: 'Ext.window.Window',
	alias: 'widget.timeTableCourseRegistration',
	autoScroll: true,
	modal : true,
	height: '90%',
	width: '90%',
	layout: 'fit',
	title: getCommonTranslation('TIME_TABLE_COURSE_REGISTRATION'),
	frame: false,
	items: [{
		xtype: 'form',
		itemId: 'timeTableDetailsForm',
		method: 'POST',
		autoScroll:false,
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'vbox'
			},
			defaults :{
				width: '80%',
				labelAlign: 'left',
				margin: '0 10px 10px 10px',
				labelWidth: 150,   
			},
			items:[{
				xtype: 'displayfield',
				name: 'courseName',
				itemId:'courseName',
				style: {
					margin: '0 10px 10px 10px',
				},
				fieldLabel: getCommonTranslation('COURSE_NAME')
			},{
				xtype: 'multiselectcombofield',
				name: 'courseVarient',
				allSelector: false,
				itemId: 'courseVarient',
				fieldLabel: getCommonTranslation('COURSE_VARIENT'),
				valueField: 'variantId',
				displayField: 'variantCode',
				multiSelect: true,
				style: {
					margin: '0 10px 10px 10px',
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;

							var combo = picker.up('combobox'),
							comboInputWidth = combo.inputEl.dom.offsetWidth + 48;

							picker.setWidth(comboInputWidth);
						}
					}
				},
				listeners: {
					focus: function(combo) {
						var picker = combo.picker,
						comboInputWidth = combo.inputEl.dom.offsetWidth + 48;

						picker.setWidth(comboInputWidth);
					},
					expand: function(combo) {
						combo.ignoreSelection = 0;
					}
				}
			},{
				xtype: 'tabpanel',
				itemId: 'variantTabs',
				flex: 1,
				width: '100%',
				height: 'auto',
				margin: '10 10 10 10',
				cls: 'contentPanel',
				/*style: {
				    overflow: 'hidden'
				},*/
				listeners: {
				    afterrender: function (tabPanel) {
				        var tabBar = tabPanel.down('tabbar');

				        if (tabBar && tabBar.el) {
				            // Force scroller to always show

				            // Get left and right scrollers
				            var leftScroller = tabBar.el.down('.x-box-scroller-left');
				            var rightScroller = tabBar.el.down('.x-box-scroller-right');
				            var activeScroller = tabBar.el.down('.x-tab-bar-default .x-box-scroller');
				            var disabledScroller = tabBar.el.down('.x-tab-bar-default .x-box-scroller-disabled');

				            if (leftScroller) {
				                leftScroller.setStyle({
				                    'float': 'left',
				                    'height': '30px !important',
				                    'width': '24px !important',
				                    'z-index': 5,
				                    'border': '1px solid #bfd0b1;',
				                    'border-right': '1px solid #ccc'
				                });
				            }
				            if (activeScroller) {
				            	activeScroller.setStyle({
				            		'opacity': '1 !important'
				            	});
				            }
				            if (disabledScroller) {
				            	disabledScroller.setStyle({
				            		'opacity': '0.5 !important'
				            	});
				            }

				            if (rightScroller) {
				                rightScroller.setStyle({
				                    'float': 'right',
				                    'height': '30px !important',
				                    'width': '24px !important',
				                    'z-index': 5,
				                    'border': '1px solid #bfd0b1;',
				                    'border-left': '1px solid #ccc'
				                });
				            }
				        }
				    }
				}

			}]
		}]
	}]
});
