var StudentPortalProgramPeriodEnrollGridStore = Ext.create('Academia.store.coursetransaction.manageperiodenrollment.StudentPortalProgramPeriodEnrollGridStore');
var myNewModel = Ext.define('MyNewModel', {
	extend : 'Ext.data.Model',
	fields : [ 'id','value','code','sequence','displayOtherLanguage','periodYearId',{
		name: 'myId',
		convert : function (v, rec) {
			return randomString(10);
		}
	}],
	idProperty: 'myId'
});
/*var paymentTermComboStore = Ext.create('Ext.data.ArrayStore',{
	model : 'Academia.model.common.IdValueCodeDataModel'
});*/ //Ext.create('Academia.store.feeandpayment.FeePaymentTerm');
Ext.define('Academia.view.coursetransaction.studentperiodenrollment.StudentPeriodEnrollmentList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentperiodenrollmentlist',
	store : StudentPortalProgramPeriodEnrollGridStore,
	title: getCommonTranslation('LIST_OF_PROGRAMS_PERIOD'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'studentperiodregistration':3
		}
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : StudentPortalProgramPeriodEnrollGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	listeners:{
		beforeselect:function(selModel,record,index){
			if(!isNullOrEmpty(selModel.view.up())){
				var gridItemId = selModel.view.up().getItemId();
				if(!isNullOrEmpty(record.get('status')) && record.get('status') == "Pending"){
					return true;
				}else{
					selModel.view.up().down('#save').setDisabled(true);
					selModel.view.up().down('#showEnrollmentMessageId').setVisible(false);
					return false
				}
			}
		},
		beforerender: function(grid){
		}
	},
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('ENROLL'),
		itemId: 'save',
		disabled:true
	},{
		xtype:'displayfield',
		name : 'showEnrollmentMessage',
		itemId : 'showEnrollmentMessageId',
		hidden:true
	}],
	columns : [{
		header : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex : 'programCodeValue',
		flex:1
	},{
		header : getCommonTranslation('PERIOD_NAME'),
		dataIndex : 'periodName',
		flex:1
	},{ 
		header : getCommonTranslation('PAYMENT_TERM'),
		dataIndex : 'paymentTerm',
		sortable: false,
		flex : 1.5,  
		editor : {
			xtype: 'customcombobox',
			itemId: 'paymentTerm',
			name: 'paymentTerm',
			width: 135,
			labelAlign: 'top',
			store:Ext.create('Ext.data.ArrayStore',{
				model : 'MyNewModel'
			}),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			queryMode: 'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						var combo = picker.up('combobox');
						var comboStore = combo.getStore();
						var grid = combo.up('grid');
						if(!isNullOrEmpty(grid.getSelectionModel().getSelection()) && grid.getSelectionModel().getSelection().length){
							var record = grid.getSelectionModel().getSelection()[0];
							var periodId = record.data.periodId;
							comboStore.clearFilter();
							comboStore.loadData(allPaymentTerms);
							comboStore.filterBy(function(storeRecord, id){
								return (storeRecord.get('displayOtherLanguage') == periodId);
							});
						}

						picker.minWidth = picker.up('combobox').getSize().width;
					},
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')

				},
			},
			listeners:{
				select:function(obj, record){
					var grid=obj.up('grid');
					var dataItems =grid.getStore().data.items;
					var newArray =[]
					if(!isNullOrEmpty(record[0].data.periodYearId)){
						if(dataItems.length >0) {
							for(var i=0; i< dataItems.length;i++){
								if(!isNullOrEmpty(dataItems[i].data.paymentTerm)){
									if((record[0].data.periodYearId == dataItems[i].data.periodYear) && (dataItems[i].data.status == "Pending")){
										newArray = allPaymentTerms.filter(function (el) {
											return (el.displayOtherLanguage == dataItems[i].data.periodId && el.id == record[0].data.id)
										});
										if(newArray.length >0) {
											dataItems[i].set('paymentTerm',record[0].data.id)
										}
									}

								}
							}
						}
					}

				}
			},
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			try{
				var periodId = record.data.periodId;
				rec.column.getEditor().getStore().clearFilter();
				rec.column.getEditor().getStore().loadData(allPaymentTerms);
				rec.column.getEditor().getStore().filterBy(function(storeRecord, id){
					return (storeRecord.get('displayOtherLanguage') == periodId);
				});
				var index = rec.column.getEditor().store.findExact('id',value);
				if(index !== -1){
					record.data.paymentTermName = rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
				}else
				{

					var storeRec = rec.column.getEditor().getStore().data.items;
					for(var i=0;i<storeRec.length;i++)
					{
						if(!isNullOrEmpty(storeRec[i].data.displayOtherLanguage))
						{
							if(storeRec[i].data.displayOtherLanguage==record.data.periodId && storeRec[i].data.sequence==1)
							{
								if(record.data.status == 'PENDING' || record.data.status == 'Pending' || record.data.status == 'pending'){
									record.set('paymentTerm',storeRec[i].data.id);
									record.set('paymentTermName', storeRec[i].data.value);
									return storeRec[i].data.value;
									break;
								}
							}
						}
					}
				}
			}
			catch(e){
				record.set('paymentTermName', '');
				return null ;
			}
		}
	},{
		header : getProgramandcourseTranslation('PERIOD_START_DATE'),
		dataIndex : 'periodStart',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('PERIOD_END_DATE'),
		dataIndex : 'periodEnd',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getProgramandcourseTranslation('REGISTRATION_START_DATE'),
		dataIndex : 'registrationStartDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('REGISTRATION_END_DATE'),
		dataIndex : 'registrationEndDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('LAST_DATE_OF_ENROLLMENT'),
		dataIndex : 'enrollmentLastDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('PERIOD_ENROLLMENT_STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if(value=='Enrolled') {
				return '<span style="color:green">'+value+'</span>'
			}else if(value=='Passed'){
				return '<span style="color:green">'+value+'</span>'
			}else if(value=='Pending'){
				return '<span style="color:red">'+value+'</span>'
			}else if(value=='Request Received'){
				return '<span style="color:#D2691E">'+value+'</span>'
			}else {
				return value;
			}
		}
	},{
		header : getCommonTranslation('PROMOTION_STATUS'),
		dataIndex : 'promotionStatus',
		flex:1
	},
	{
		header : getProgramandcourseTranslation('REGISTRATION_STATUS'),
		dataIndex : 'registrationStatus',
		flex : 1,
		renderer:function(value){
			if(!isNullOrEmpty(value)) {
				if(value=="Not Started"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="In Progress"){
					return "<font color='#D2691E'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="Open"){
					return "<font color='green'>" +  getCommonTranslation(value)+"</font>";
				}else if(value=="Closed"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}else {
					return "-";
				}
			} else{
				return "-";
			}
		} 

	}],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(editor, context) {
				if(editor.context.field == 'paymentTerm'){
					for(var i=0;i<context.grid.columns.length;i++){
						if (context.grid.columns[i].dataIndex=='paymentTerm')
						{
							//--- on focus code here

							var admissionId = context.record.data.admissionId;
							var periodId = context.record.data.periodId;
							context.grid.columns[i].getEditor().getStore().clearFilter();
							context.grid.columns[i].getEditor().getStore().loadData(allPaymentTerms);
							context.grid.columns[i].getEditor().getStore().filterBy(function(storeRecord, id){
								return (storeRecord.get('displayOtherLanguage') == periodId);
							});
							if(!isNullOrEmpty(context.record.data.paymentTerm)&&(context.record.data.status=="Enrolled" || context.record.data.status=="Request Received" || context.record.data.status=="In Progress" || context.record.data.status=="Passed")){
								context.record.set('paymentTerm',context.record.data.paymentTerm);
								context.grid.columns[i].getEditor().setReadOnly(true);
								context.grid.columns[i].getEditor().setValue(context.record.data.paymentTerm)
							}

							//--- on focus code ends here

							if(context.record.data.status == 'ENROLLED' || context.record.data.status == 'Enrolled' || context.record.data.status=="REQUEST_RECEIVED" || context.record.data.status=="Request Received" || context.record.data.status=="In Progress" || context.record.data.status=="Passed"){
								context.grid.columns[i].getEditor().setReadOnly(true);

							}else{
								context.grid.columns[i].getEditor().setReadOnly(false);
								context.grid.columns[i].getEditor().enable(true);

							}
						}}}
			}
		}
	}
});
