/**
 * @author Pravin.Surve
 * 
 */
Ext.define('Academia.view.criteriabuilder.SaveCriteriaOfAdvanceSearch', {
	extend: 'Ext.window.Window',
	alias : 'widget.savecriteriaofadvancesearch',
	modal: true,
	title: 'Save Search',
	items: [{
        defaults: {
        	labelAlign:'top',
        	width: 226
          },
        xtype: 'form',
        items: [{
            xtype: 'textfield',
            itemId: 'nameCriteria',
            allowBlank: false,
            name: 'nameCriteria',
            fieldLabel: getCommonTranslation('SEARCH_CRITERIA_NAME'),
            vtype: 'NoSpeceAndSpecialCharacters',
            vtypeText: getCommonTranslation('ONLY_NUMBERS_AND_CHARACTERS_ARE_ALLOWED')
        },{
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                action: 'Submit',
                formBind: true,
                text: getCommonTranslation('SAVE'),
                itemId: 'saveAdvanceSearchCriteria',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                handler: function() {
                	var advancedSearchQueryBuilderView = this.up('window').criteriaSearch;
                	advancedSearchQueryBuilderView.saveSearchCriteriaFunction(this.up('window'));
				}
            },{
                xtype: 'button',
                itemId: 'cancelAdvanceSearchCriteria',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler: function() {
                	this.up('window').close();
				}
            }]
        }]
    }]
	
});