/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.criteriabuilder.userquicksearch.UserUpdateDownloadForm', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.userupdatedownloadform',
	frame: false,
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'form',
		//itemId: 'userQuickSearchForm',
		method: 'POST',
		margin: 0,
		padding: 0,
		width: '100%',
		defaults: {
			labelAlign: 'top'
		},
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: 'User ID',
				name: 'userId',
				itemId: 'userItemId',
				store: 'criteriabuilder.userquicksearch.QuickSearchCode',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam: 'code',
				minChars: 3,
				typeAhead: false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents: 'true',
				hideTrigger: false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' + '{value}' + '</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				fieldLabel: 'User Name',
				name: 'userName',
				itemId: 'userNameItemId',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				typeAhead: false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents: 'true',
				hideTrigger: false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' + '{value}' + '</div>';
					}
				}
			}, {
				xtype: 'fieldcontainer',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: 'User Belongs To',
					name: 'whetherInternal',
					itemId: 'whetherInternalItemId',
					editable: false,
					store: 'user.UserTypeStore',
					displayField: 'id',
					valueField: 'value',
					queryMode: 'local'
				}, ]
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			layout: 'hbox',
			items: [{
				xtype: 'customcombobox',
				name: 'userGroupId',
				itemId: 'userGroupItemId',
				fieldLabel: getCommonTranslation('USER_TYPE'),
				store: 'userGroup.UserGroupStore',
				valueField: 'id',
				displayField: 'userGroupName',
				editable: false
			}, {
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('ROLE'),
				name: 'roleId',
				itemId: 'roleItemId',
				store: 'securitysetup.ActiveRolesStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				minChars: 3,
				hideTrigger: false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' + '{value}' + '</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'departmentId',
				itemId: 'departmentItemId',
				fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
				valueField: 'id',
				displayField: 'name',
				editable: false,
				triggerAcation: 'all',
				fourceSelection: true,
				store: 'department.ParentDepartmentByAccesibleStore'
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			layout: 'hbox',
			items: [{
				xtype: 'customcombobox',
				name: 'gender',
				itemId: 'genderItemId',
				fieldLabel: getCommonTranslation('GENDER'),
				valueField: 'id',
				displayField: 'value',
				store: 'Academia.store.common.GenderTypeStore',
				editable: false
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			layout: 'hbox',
			items: [{
				xtype: 'customcombobox',
				name: 'academyLocationId',
				itemId: 'academyLocationItemId',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
				editable: false,
				store: 'user.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id'
			}, {
				xtype: 'checkboxfield',
				name: 'userWithoutAL',
				itemId: 'userWithoutALItemId',
				boxLabel: getCommonTranslation('USER_WITHOUT_ACADEMY_LOCATION'),
				width: 'auto',
				style: 'margin-top: 25px',
				labelAlign: 'right',
				inputValue: true
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
				itemId: 'downoladBtnId',
				hidden: false,
				ui: 'CustomBtnSubmit'
			}, {
				xtype: 'button',
				text: getCommonTranslation('CLEAR_SEARCH'),
				ui: 'CustomBtnCancel', 
				itemId: 'resetBtnItemId',
				scale: CONSTANTS.BUTTONSIZE,
			}]
		}]
	}]
});