/**
 * @author sachin.bangar
 * 
 * This component is used for layout of Custom Fields Tab 
 */
Ext.define('Academia.view.customcategories.CustomCategory', {
    extend: 'Ext.tab.Panel',
    alias: 'widget.customcategory',
    autoScroll: true,
    plain: true,
    cls: 'horizontal-scrolling-fix',
    style: {
        overflow: 'hidden !important',
        margin: '0!important'
    },
    activeTab: 0,
    defaults: {
        autoscroll: false,
        margin: 0
    },
    items: [{
        xtype: 'panel',
        autoScroll: true,
        title: getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'),
        cls: 'panelNoSpace',
      itemId: 'standardMasterGridPanel',
      items: [{
          xtype: 'customcategorystandardmastergrid',
          itemId: 'customCategoryStandardMasterGrid'
      }]	
  }, {
      xtype: 'panel',
      autoScroll: true,
      title: getCommonTranslation('CUSTOM_CATEGORIES'),
      cls: 'panelNoSpace',
      autoScroll: true,
      itemId: 'customCategoryGridPanel',
      layout: {
          type: 'hbox'
      },
      items: [{
          xtype: 'customcategorygrid',
          itemId: 'customCategoryGrid',
          flex: .5
      }, {
          xtype: 'customcategoryvaluesgrid',
          itemId: 'customCategoryValuesGrid',
          flex: .5,
          style:{
        	  position:'relative !important'
          }
      }]
  }]
});