/**
 * @author sachin.bangar
 * 
 * This form is used for standard master custom category
 */
Ext.define('Academia.view.customcategories.StandardMasterCustomCategoryForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.standardmastercustomcategoryform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'id_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'whetherCustomField',
        value: false
    }, {
        xtype: 'hidden',
        name: 'customFieldDataType',
        value: 'COMBOBOX'
    }, {
        xtype: 'hidden',
        name: 'whetherStandardMaster',
        value: true
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
           	xtype: 'nestedJsonCombo',
    		name: 'customTableConfig',
    		fieldLabel:getCommonTranslation('ENTITY_NAME'),
    		itemId: 'customTableConfigField',
    		labelWidth: 80,
            width: 226,
    		valueField: 'id',
    		displayField: 'value',
    		queryParam:'displayName',
    		minChars:3,
    		typeAhead:false,
    		forceSelection:true,
    	    allowBlank: false,
    	    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    	    enableKeyEvents  : 'true',
    	    hideTrigger:false,
    	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	    triggerAction: '',
    	    listConfig: {
    	    	listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    	        loadingText: getCommonTranslation('SEARCHING'),
    	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	        getInnerTpl: function() {
    	            return '<div class="search-item">' +
    	                '{value}' +
    	            '</div>';
    	        }
    	    },
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.customcategories.TableConfigCategoryMasterSearchStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('COLUMN_NAME'),
            editable : false,
            allowBlank: false,
            disabled: true,
            name: 'columnMapping',
            itemId: 'columnNameField',
            valueField: 'id',
            displayField: 'value',
            store:'customcategories.TableColumnConfigStore'
          /*  listeners: {
            	render: function(combo) {
                    var store = Ext.create('Academia.store.customcategories.TableColumnConfigStore');
                    combo.bindStore(store);
                }
            }*/
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('CATEGORY_NAME'),
            itemId : 'categoryNameField',
            name: 'displayName',
            allowBlank: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('STANDARD_MASTER_CATEGORY'),
            store : 'customcategories.StandardMasterCategoryStore',
            editable : false,
            allowBlank: false,
            name: 'standardMasterCategory',
            itemId: 'columnNameField',
            valueField: 'id',
            displayField: 'value'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('DISPLAY_ORDER'),
            itemId : 'dispalyOrderField',
            name: 'displayOrder',
            minValue: 0,
            allowBlank: false
        }, {
            xtype: 'checkboxfield',
            itemId : 'whetherMandatoryField',
            labelAlign: 'right',
            style: {
                marginTop: '25px',
                marginLeft:'5px'
            },
            boxLabel: getCommonTranslation('CUSTOM_CATEGORY_MANDATORY'),
            name: 'whetherMandatory',
            inputValue: true,
            uncheckedValue: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});