Ext.define('Academia.view.dashboard.dashlets.ColumnChartDashlet', {
	extend : 'Ext.chart.Chart',
	alias : 'widget.columnchartdashlet',
	   requires: ['Ext.chart.axis.OverlapLabelOptions'], // added for get rid of not showing  bigger length labels
	    animate: true,
	    shadow: true,
	    
	    initComponent: function() {
	        var this$ = this;
	        
	        var numberField = this.yAxesNumericField || 'number'; 
	        var categoryField ='category';
	        var numericTitle = this.yAxesNumericTitle|| getCommonTranslation('NUMERIC_TITLE');
	        var categoryTitle = this.xAxesCategoryTitle||getCommonTranslation('CATEGOTY_TITLE');
	        var columnWidth = this.columnWidth|| REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
	        var columnColor = this.columnColor|| REPORT_CONSTANTS.COMMON_COLOR;
	        var chartStore = this$.buildStore();
	        	
	        Ext.apply(this$, {
	        	store: chartStore,
	            axes: [{
	                type: 'Numeric',
	                position: 'left',
	                fields: [numberField],
	                label: {
	                    renderer: Ext.util.Format.numberRenderer('0,0')
	                },
	                title: numericTitle,
	                grid: true,
	                minimum: 0
	            }, {
	                type: 'Category',
	                position: 'bottom',
	                fields: [categoryField],
	                title: categoryTitle,
	                //below options added for get rid of not showing bigger length labels 
	                //labelRows: 2,
	                //hideOverlappingLabels: false,
	                label   : {
	                	rotate:{degrees:45},
	                	 renderer: function(s) {
	 	                	if(Ext.String.ellipsis(s,10)){
	 	                		 return Ext.String.ellipsis(s,10);
	 	                	}else{
	 	                		return 'loading...';
	 	                	}
	 	                   }
	                }
	            }],
	            series: [{
	                type: 'column',
	                axis: 'left',
	                xField: categoryField,
	                yField: numberField,
	                gutter : 40,
	                highlight: true,
	                tips: {
	                  trackMouse: true,
	                  height: 30,
	                  layout: 'fit',
	                  renderer: function(storeItem, item) {
	                	  var tipTitle = storeItem.get(categoryField) + ' : ' + storeItem.get(numberField);
	                	  var heightcount = (storeItem.get(categoryField).match(/<br>/g) || []).length;
	                	  if(heightcount!=0)
	                	  {
	                		  this.setHeight(heightcount*25);
	                		  var length = (tipTitle.length)* 3.1;
	                	  }else
	                	  {
	                		  var length = (tipTitle.length)* 10;
	                	  }
	                	  this.setWidth(length);
	                	  this.setTitle(tipTitle);
	                  }
	                },
	                renderer: function(sprite, storeItem, barAttr, i, store) {
	                	barAttr.fill = columnColor;
	                	barAttr.width = columnWidth;
	              	  	return barAttr;
	                },
	                style: {
	                    'stroke-width': 0,
	                    'stroke': '#fff'
	                },
	                renderer: function(sprite, record, attr, index, store) {
//	                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
	                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
	                	var color = baseController.getRandomColor(index);
	                    if(store.getCount() <= 5){
	                		return Ext.apply(attr, {
	                            fill: color,
	                            width: 30,
	                            x: Math.max(attr.x, attr.x + (attr.width - 30) / 2)
	                        });
	                	}
	                	else{
		                    return Ext.apply(attr, {
		                        fill: color
		                    });
	                	} 
	                }
	            }]
	        });

	        this$.callParent(arguments);
	    },

createPostGridStore: function(columnModel, url, params,fields1,xAxesCategoryField) {
    var store = Ext.create('Ext.data.Store', {
    	model : columnModel,
    	fields : fields1,
        autoDestroy: true,
        autoLoad: false,
        pageSize: CONSTANTS.DEFAULT_PAGESIZE,
        extraParams: params,
        proxy: {
    		type : 'jsonajax',
    		header: {
                contentType: 'application/json'
            },
            actionMethods: {
                read: 'POST'
            },  
    		api : {
    			 read: url
    		},
    		reader : {
    			type : 'json',
    			root : 'rows',
    			totalProperty: 'records'
    		},
            extraParams: params
        },
        listeners:{
       	 load: function(store,option,success){
             for(var i=0; i< store.getCount(); i++){
                 var record = store.getAt(i);
                 var value='';
                 for(var j=0; j< xAxesCategoryField.length-1; j++){
                	 value=value + record.get(xAxesCategoryField[j])+"<br>";
                 }
            	 value=value + record.get(xAxesCategoryField[j]);
                 record.set("category",value);
             }
             store.commitChanges();
    	 }
        }
    });
    return store;
},

buildStore: function(xAxesCategoryField) {
    return this.createPostGridStore(this.model,this.url, this.params,this.fields,this.xAxesCategoryField );
}

});
