Ext.define('Academia.view.dashboard.dashlets.GridDashletGetMethod',{
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.griddashletgetmethod',
    addPagingToolbar : true,
    border: true,
    viewConfig: {
        stripeRows : CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store
        });
        if(this$.addPagingToolbar){
	        Ext.apply(this$, {
		        dockedItems: [{
		            xtype: 'toolbar',
		            dock: 'bottom',
		            items: [{
		                xtype: 'custompagingtoolbar',
		                plugins: ['pagesize'],
		                store: store,
		                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
		                displayInfo: true
		            }]
		        }]
	        });
        }
        this$.callParent(arguments);
    },
    
    createPostGridStore: function(columnModel, url, params,fields1) {
        var store = Ext.create('Ext.data.Store', {
        	model : columnModel,
        	fields : fields1,
            autoDestroy: true,
            autoLoad: false,
            pageSize: CONSTANTS.DEFAULT_PAGESIZE,
            extraParams: params,
            proxy: {
        		type : 'rest',
                actionMethods: {
                    read: 'GET'
                },  
        		api : {
        			 read: url
        		},
        		reader : {
        			type : 'json',
        			root : 'rows',
        			totalProperty: 'records'
        		},
                extraParams: params
            }
        });
        return store;
    },
    
    buildStore: function() {
        return this.createPostGridStore(this.model,this.url, this.params,this.fields);
    }
});
    
        
