/**
 * @author Prakash Sharma
 */

var academicDetailsTemplate = new Ext.XTemplate('<tpl for="."><div>', 
		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
		'<tr style="height: 30px;color:black" >', 
		'<td style="">'+ getCommonTranslation('PARENT_GUARDIAN_NAME') +': </td>',
		'<td style=""><span>{printName}</span></td>', 
		'</tr>',
		'<tr style="height: 30px;color:black">',
		'<td style="">'+ getCommonTranslation('LOGIN_USERNAME') +': </td>',
		'<td ><span>{userCode}</span></td>',
		'</tr>',
		'<tr style="height: 30px; color:black">', 
		'<td style="">'+ getCommonTranslation('CELL_PHONE') +': </td>',
		'<td ><span>{mobileCountryCode} {mobileNumber}</span></td>', 
		'</tr>', 
		
		'<tr style="height: 30px;color:black;">', 
		'<td style="">'+ getCommonTranslation('ALTERNATE_MOBILE_NUMBER') +': </td>',
		'<td ><span>{alternetMobileCountryCode} {alternateMobileNo}</span></td>', 
		'</tr>', 
		
		'<tr style="height: 30px;color:black">', 
		'<td style="">'+ getAdmissionTranslation('EMAIL_ADDRESS') +': </td>',
		'<td style="word-wrap: break-word;width:100px;"><span>{emailId}</span></td>', 
		'</tr>', 
		
'</table></div></tpl>');


Ext.define('Academia.view.dashboard.dashlets.ParentGuardianStudentPortalDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.parentguardianstudentportaldashlet',
   /* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.store.feeandpayment.managebill.Student',
               'Academia.store.feeandpayment.StudentDetailsByStudentId' ], */
    graphView:true,
    layout:'card',
    cls:'StudentParentGuardianPersonalDashletCLS dashlet',
    activeItem: 0, 
    loadDashlet :function(){
    	var this$=this;
    	var userInfo = Academia.model.authentication.UserInfoModel;
 		var portal =  userInfo.get('portalId');
 		var studentId = "";
 		var personId = "";
 		var studentCode= "";
 		var obj = this$.down("#studentlookupsearch");
    	this$.fireEvent('refreshstudentlookupdashlet',obj);
 		if(portal == 3){
 			studentlookupdashlet = obj;
 			studentId =  this$.getCurrentlyLoggedInUserInfoForPortalDashlet().student.id;
 			personId = this$.getCurrentlyLoggedInUserInfoForPortalDashlet().student.person.id;
 			var studentField = this$.down('#student');
 			studentField.setVisible(true);
 			var dropdownStore = studentField.getStore();
 			dropdownStore.getProxy().extraParams={
 				studentPersonId:personId
			};
 			//dropdownStore.load();
 			dropdownStore.load({
				callback : function(records, operation, success) {
					if (success) {
						if (records.length == 0) {
							var noRecordFoundImagePanelItemId = this$.down("#noRecordFoundImagePanelItemId");
							var recordPanelItemId = this$.down("#recordPanelItemId");
							noRecordFoundImagePanelItemId.setVisible(true);
							recordPanelItemId.setVisible(false);
							
						}else{
							var idToSet = null;
			 				//var storeData = dropdownStore.data.items;
			 				Ext.each(records, function(item) {
			 					if (item.data.code == 'FATHER') {
			 						idToSet = item.data.id;
			 					}
			 				});
			 	 			var academicdataview = this$.down("#academicdataview");
			 				var academicStore= academicdataview.getStore();
			 				academicStore.getProxy().extraParams={
			 					parentPersonId:idToSet
			 				};
			 				academicStore.load();
			 				if (idToSet != null) {
			 					studentField.setValue(idToSet);
							}
						}
						
					}
				}

			});
 			
 			
 		//	this$.down('#studentlookupsearch').setVisible(false);
 		}else if(portalId == 2) {
 			var studentField = this$.down('#student');
 			var studentStore = studentField.getStore();
 			 var alinfomodel = Academia.model.authentication.ALInfoModel;
			 var whetherSchool = alinfomodel.get('wheatherSchool');
			 var submitUrlValue=null;
			 if(whetherSchool){
				 submitUrlValue=SERVERURL.BILL_STUDENT_DETAILS_BY_STUDENT_CODE+'?whetherSchool='+whetherSchool+'&page='+1+'&start='+0+'&limit='+500
			 } else {
				 submitUrlValue=SERVERURL.PATH_FIND_FACULTY_TEACHING_STUDENTS+'?whetherSchool='+whetherSchool
			 }
			 
 			var submitURL=submitUrlValue;
		    studentStore.getProxy().api.read=submitURL;
		    if(!isNullOrEmpty(studentField.valueModels[0])){
 				studentId = studentField.valueModels[0].get("id");
 	 			personId = studentField.valueModels[0].get("personId");
 	 			studentCode=studentField.valueModels[0].get('studentCode');
 			} 
 		}else{
 			var studentField = this$.down('#student');
 			if(!isNullOrEmpty(studentField.valueModels[0])){
 				studentId = studentField.valueModels[0].get("id");
 	 			personId = studentField.valueModels[0].get("personId");
 	 			studentCode=studentField.valueModels[0].get('studentCode');
 			} 
 		}
 		if(portal == 3){
 			 setTimeout(function(){
 				var image = this$.down('#profile_image');
 				var studentField = this$.down('#student');
 				var personId =  studentField.getValue();
 				if(!isNullOrEmpty(personId)){
 					Ext.Ajax.request({
 						type: 'rest',
 						binary: true,
 						url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
 						method: 'GET',
 						success : function(response){
 							if(response.responseBytes.length>0){
 								var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
 								var url = window.URL.createObjectURL(blob);
 								image.getEl().dom.src=url;
 							}
 						}
 					});
 				}
 			 },1500);
		}
    },
	defaults: {
		cls: 'horizontalScrollingFixed',
    },
    items: [{
    	xtype:'panel',
    	border: true,
    	autoScroll:true,
    	layout:'hbox',
    	margin : 0,
    	itemId:'recordPanelItemId',
    	cls : 'horizontalScrollingFixed',
    	width:'100%',
    	items:[{
    		xtype: 'panel',
    		width:'30%',
    		layout:'vbox',
    		items:[{
    			xtype:'image',
    			itemId: 'profile_image',
    			border: 1,
    			style: {
    				borderColor: '#e0e0e0',
    				borderStyle: 'solid',
    				margin:'10px 0px 0px 0px',
    				borderRadius:'50%'
    			},
    			width: 100,
    			height: 100
    		}]
    	},{
    		xtype: 'panel',
    		width:'70%',
    		layout:'vbox',
    		items:[{
    			xtype: 'text',
    			text : 'Personal Details:',
    			style:'{font-weight:bold;color:black}'
    		},{
    			xtype:'panel',
    			border:false,
    			frame:false,
    			cls:'panelNoSpace',
    			layout:'fit',
    			items: [{
    				xtype:'dataview',
    				itemId:'academicdataview',
    				store :'Academia.store.dashboard.FindParentGuardianDetailDashletStore',
    				tpl: academicDetailsTemplate,
    				multiSelect:true,
    				autoHeight:true,
    				itemSelector:'div.innerGrid'
    			}]
    		}]
    	}]
    },{  xtype: 'panel',
 		width: '95%',
	 	itemId:'noRecordFoundImagePanelItemId', 
	 	height: '80%',
	 	autoScroll: false,
	 	html: '<div><div class ="dashletParentNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>', 
	 	style:{ 'overflow': 'hidden !important;' }
    }],
    tbar: {
        cls: 'studentlookupdashbordTbar',
        style:{marginLeft:'-10px'},
        items: [{
			xtype: 'nestedJsonCombo',
			name: 'student',
			itemId:'student',
			width:'40%',
			style:{marginLeft:'10px'},
			store: 'Academia.store.dashboard.FindParentGuardianDashletStore',
			//Academia.store.dashboard.ExamBoardStore
            valueField: 'id',
			displayField: 'value',
            editable : false,
            emptyText: 'Select Parent',
            allowBlank:true,
            hideTrigger:false,
            triggerAction: 'all',
            forceSelection:true
        
        }]
    }
});

