Ext.define('Academia.view.dashboard.dashlets.StackBarChartVerticalDashlet', {
	extend : 'Ext.chart.Chart',
	alias : 'widget.stackbarchartverticaldashlet',
	requires: ['Ext.chart.axis.OverlapLabelOptions'], // added for get rid of not showing  bigger length labels
    animate: true,
    shadow: true,
    title : getProgramandcourseTranslation('PENDING_ATTENDANCE_REPORT'),
    initComponent: function() {
        var this$ = this;
        
        var numberField = this.yAxesNumericField || 'number'; 
        var categoryField =this.xAxesCategoryField || 'category';
        var numericTitle = this.yAxesNumericTitle|| getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = this.xAxesCategoryTitle||getCommonTranslation('CATEGOTY_TITLE');
        var columnWidth = this.columnWidth|| REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
        var columnColor = this.columnColor|| REPORT_CONSTANTS.COMMON_COLOR;
        var titleLegend= this.titleLegend;
        var headingTitle= this.headingTitle;
        var chartStore = this$.buildStore();
        Ext.apply(this$, {
        	store: chartStore,
            axes: [{
                type: 'Numeric',
                position: 'left',
              //  fields: [numberField],
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                },
                title: numericTitle,
                labelTitle: { font: 'bold 12px Arial' },
                grid: true,
                minimum: 0
            }, {
                type: 'Category',
                position: 'bottom',
                fields: [categoryField],
                title: categoryTitle,
                label   : {
                	font: '10px Arial',
                renderer: function(s) {
                    return Ext.String.ellipsis(s,20);    
                   }
                }
            }],
            legend: {
                docked: 'bottom',
                 style: {
                    stroke: '#ffffff',
                    'stroke-width': 2,
                    opacity: 1
                },
                tpl: [
                    '<tpl for=".">               ',
                    '                <div class="myLegendItem" style="float:left;margin:5px;padding:0px;cursor:pointer;">',
                    '                      <div class="" style="float:left;margin:2px;width:12px;height: 12px; background:{mark};"></div><div style="float:left;">{name}</div>                                     ',
                    '                </div>                    ',
                    '            </tpl>'
                ],
                itemSelector: '.myLegendItem'
            },
            series: [{
                type: 'column',
                axis: 'left',
                xField: categoryField,
                yField: numberField,
                gutter : 100,
                title: titleLegend,
                highlight: true,
                stacked: true,
                tips: {
	                  trackMouse: false,
	                  width:140,
	                  height:28,
	                  renderer: function(storeItem, item) {
	                	  //this.setWidth(100);
	                	  try{
	                		  if(item.attr.fill == "#94ae0a"){
	                			  this.setTitle("Present" + "-"+storeItem.data.totalPresents);
	                		  }else if(item.attr.fill == "#a61120"){
	                			  this.setTitle("Absent" + "-"+storeItem.data.totalAbsents);
	                		  }else if(item.attr.fill == "#115fa6"){
	                			  this.setTitle("Leave" + "-"+storeItem.data.totalLeaves);
	                		  }
	                	  }
	                	  catch(e){
	                		  console.log(e);
	                	  }
	                  }
	                },
	                renderer: function(sprite, storeItem, barAttr, i, store) {
	                	//barAttr.fill = columnColor;
	                	barAttr.width = 30;
	              	  	return barAttr;
	                },
            }]
        });

        this$.callParent(arguments);
    },

createPostGridStore: function(columnModel, url, params,fields1,xAxesCategoryField) {
var store = Ext.create('Ext.data.Store', {
	model : columnModel,
	fields : fields1,
    autoDestroy: true,
    autoLoad: false,
    pageSize: CONSTANTS.DEFAULT_PAGESIZE,
    extraParams: params,
    proxy: {
		type : 'jsonajax',
		header: {
            contentType: 'application/json'
        },
        actionMethods: {
            read: 'POST'
        },  
		api : {
			 read: url
		},
		reader : {
			type : 'json',
			root : 'rows',
			totalProperty: 'records'
		},
        extraParams: params
    },
    listeners:{
   	 load: function(store,option,success){
         for(var i=0; i< store.getCount(); i++){
             var record = store.getAt(i);
             var value='';
             for(var j=0; j< xAxesCategoryField.length-1; j++){
            	 value=value + record.get(xAxesCategoryField[j])+"#";
             }
        	 value=value + record.get(xAxesCategoryField[j]);
             record.set("category",value);
         }
         store.commitChanges();
	 }
    }
});
return store;
},

buildStore: function(xAxesCategoryField) {
return this.createPostGridStore(this.model,this.url, this.params,this.fields,this.xAxesCategoryField );
}

});