/**
 * @author Amit G
 */
Ext.define('Academia.view.dashboard.dashlets.StudentProgressHeightDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentprogressheightdashlet',

	/* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */

	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'StudentProgressWeightDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		if(view.xtype=='griddashlet' || view.xtype=='studenttipchartforheight'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			var userId = this$.getCurrentlyLoggedInDashletUser().id;
			store.getProxy().extraParams = {
				userId: userId,
				//messageType: 'Notifications'
			};
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(!isNullOrEmpty(rec) && rec.length==0){
						this$.layout.setActiveItem(2);
					}
				}
			});

			//store.load();
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},

	items:[{
		xtype : 'studenttipchartforheight',
		itemId:'studenttipchartforheightItemId',
		xAxesCategoryField :['mnthYear'],
		yAxesNumericField : 'studentHeight',
		yAxesNumericField1 : 'classAvgHeight',
		yAxesNumericField2 : 'ageAvgHeight',
		model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		url : SERVERURL.STUDENT_HEIGHT_GRAPH_DASHLET,
		listeners:{
			activate:function(portlet){
				var studentprogressheightdashlet=portlet.up('studentprogressheightdashlet');
				studentprogressheightdashlet.activeTab = 1;
				studentprogressheightdashlet.addGridViewButton(studentprogressheightdashlet);
				studentprogressheightdashlet.addExportToPng(studentprogressheightdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentprogressheightdashlet=portlet.up('studentprogressheightdashlet');
				studentprogressheightdashlet.removeGridViewButton(studentprogressheightdashlet);
				studentprogressheightdashlet.removeExportToPng();
			}
		}
	},{
		//model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		fields :['mnthYear', 'studentHeight', 'classAvgHeight', 'ageAvgHeight'],
		url : SERVERURL.STUDENT_HEIGHT_GRAPH_DASHLET,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('MONTHYEAR'),
			dataIndex: 'mnthYear',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('STUDENTHEIGHT'),
			dataIndex : 'studentHeight',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('CLASSAVG'),
			dataIndex : 'classAvgHeight',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('AGEAVG'),
			dataIndex: 'ageAvgHeight',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var studentprogressheightdashlet=portlet.up('studentprogressheightdashlet');
				studentprogressheightdashlet.addExportToPdf(studentprogressheightdashlet);
				studentprogressheightdashlet.activeTab = 0;
				studentprogressheightdashlet.addGraphViewButton(studentprogressheightdashlet);
				studentprogressheightdashlet.addExportToPdf(studentprogressheightdashlet,portlet);
				studentprogressheightdashlet.addExportToExcel(studentprogressheightdashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var studentprogressheightdashlet=portlet.up('studentprogressheightdashlet');
				studentprogressheightdashlet.removeGraphViewButton(studentprogressheightdashlet);
				studentprogressheightdashlet.removeExportToPdf();
				studentprogressheightdashlet.removeExportToExcel();
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
	
/*		xtype: 'image',
		width: '100%',
		height: '100%',
		frame : false,
		src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
*/		listeners:{
			activate:function(portlet){
				var studentprogressheightdashlet=portlet.up('studentprogressheightdashlet');
				studentprogressheightdashlet.addExportToPdf(studentprogressheightdashlet);
				studentprogressheightdashlet.activeTab = 1;
				studentprogressheightdashlet.addGraphViewButton(studentprogressheightdashlet);
				studentprogressheightdashlet.addExportToPdf(studentprogressheightdashlet,portlet);
				studentprogressheightdashlet.addExportToExcel(studentprogressheightdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentprogressheightdashlet=portlet.up('studentprogressheightdashlet');
				studentprogressheightdashlet.removeGraphViewButton(studentprogressheightdashlet);
				studentprogressheightdashlet.removeExportToPdf();
				studentprogressheightdashlet.removeExportToExcel();
			}
		}
	}]
});
