/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show dialog box for copy selected department to academy locations.   
 */
Ext.define('Academia.view.department.CopyDepartmentWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.copydepartmentwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('COPY_DEPARTMENT_TO_ACADLOC'), //Copy Department to Academy Locations			
    bodyPadding: 10,
    height: (Ext.isIE8) ? 400 : '50%',
    width: (Ext.isIE8) ? 400 : '50%',
    layout: {
        type: 'hbox'
    },
    items: [{
        xtype: 'grid',
        itemId: 'unassignedAcademyLocationList',
        store: 'department.AcademyLocationStore',
        border: true,
        flex: .45,
        height: '100%',
        autoScoll: true,
        multiSelect: true,
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        columns: [{
            dataIndex: 'id',
            hidden: true
        }, {
            header: getCommonTranslation('ACAD_LOC_ACCESS'), //Academy-Locations you have access to	
            dataIndex: 'value',
            menuDisabled: true,
            flex: 1
        }]
    }, {
        xtype: 'panel',
        itemId: 'buttonPanel',
        height: '100%',
        cls: 'list-to-list',
        layout: {
            type: 'table'
        },
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        items: [{
            xtype: 'button',
            itemId: 'btnCopyToLeft',
            ui: 'CustomBtnSubmit',
            text: '<<'
        }, {
            xtype: 'button',
            itemId: 'btnCopyToRight',
            ui: 'CustomBtnSubmit',
            text: '>>'
        }]
    }, {
        xtype: 'grid',
        itemId: 'assignedAcademyLocationList',
        store: 'department.AssignedAcademyLocationStore',
        border: true,
        flex: .45,
        height: '95%',
        autoScoll: true,
        multiSelect: true,
        columns: [{
            dataIndex: 'id',
            hidden: true
        }, {
            header: getCommonTranslation('COPY_TO_ACAD_LOC'), //Copy to Academy-Locations	
            dataIndex: 'value',
            menuDisabled: true,
            flex: 1
        }]
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        width: '100%',
        style:{
        	'padding':'0 0 0 35px !important',
        },
        height: 40,
        cls: 'windowBtnPos',
        items: [
                { xtype : 'button',				
                	itemId:'btnCopyDepartmentWindow',
                	//cls:'CustomToolbarBtnCancel',
                	//ui: 'CustomBtnSubmit',
                	text : getCommonTranslation('COPY_NOW')  //Copy Now
                },
                { xtype : 'button',
                	itemId:'btnCancelCopyDepartmentWindow',
                	//cls:'CustomToolbarBtnCancel',
                	//ui: 'CustomBtnSubmit',
                	text : getCommonTranslation('CANCEL') //cancel
                }
        ]
    }]
    /*bbar : [ {
    	xtype : 'button',				
    	itemId:'btnCopyDepartmentWindow',
    	ui: 'CustomBtnSubmit',
    	text : getCommonTranslation('COPY_NOW')  //Copy Now
    },{
    	xtype : 'button',
    	itemId:'btnCancelCopyDepartmentWindow',
    	cls:'CustomToolbarBtnCancel',
    	ui: 'CustomBtnSubmit',
    	text : getCommonTranslation('CANCEL') //cancel
    }]	*/
});