/**
 * @author Saket.Puranik
 * 
 * This component is used for to show Sub Departments details.
 */
Ext.define('Academia.view.department.SubDepartmentGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.subdepartmentgrid',
			/* requires : ['Academia.view.department.SubDepartmentFormWindow' ], */
			store : 'department.SubDepartmentStore',
			title : getCommonTranslation('SUB_DEPARTMENTS'),//Sub Departments
			collapsible:false,
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'department':1
				}
			},
			columns : [ {
				header : getCommonTranslation('SUB_DEPARTMENT_NAME'),//Sub Department Name	
				dataIndex : 'name',
				sortable : false,	
			    flex : .5
			}, {
				header : getCommonTranslation('STATUS'),//Status
			    dataIndex : 'status',	
				sortable : false,				
			    flex : .5,
			    renderer: function(value){
			    	return statusRender(value);
			    }
			}
			],						
			tbar : [ {
				xtype : 'button',				
				itemId : 'btnAdd',
				tooltip : getCommonTranslation('ADD'),//Add sub department
				glyph: ICONGLYPH.ADDGLYPH
				//text : getCommonTranslation('ADD')
			},{
				xtype : 'button',				
				itemId : 'btnEdit',
				tooltip : getCommonTranslation('EDIT'),//Edit sub department
				glyph: ICONGLYPH.EDITGLYPH
				//text : getCommonTranslation('EDIT')
			},{
				xtype : 'button',				
				itemId : 'btnView',
				tooltip : getCommonTranslation('VIEW'),//View sub department
				iconCls: 'view-icon'
				//text : getCommonTranslation('VIEW')
			},{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),//Delete sub department
				glyph: ICONGLYPH.DELETEGLYPH
				//text : getCommonTranslation('DELETE')
			}],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'department.SubDepartmentStore',
					emptyMsg : getCommonTranslation('NORESULTSNMESSAGE'),//No sub departments to display
					displayInfo : true
				} ]
			} ],
			showSubDepartmentForm: function() {				
				var winSubDepartmentFormWindow=Ext.widget('subdepartmentformwindow');
				winSubDepartmentFormWindow.show();					
			}
		}); 