/**
 * This view is used for simple document form
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.document.CourseSessionDiaryDocumentForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.coursesessiondiarydocumentform',
	autoScroll : false,   
	plugins: "formlabelrequired",
	isValidFileExtensionForCourseSessionDiary: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" || extension == "xlsx" ||
					extension == "jpg" || extension == "jpeg" || extension == "png" || extension == "zip" || extension == "rar") {
				return true;
			}
		}
		return false;
	},
	defaults : {
		labelAlign:'top',
		width: 226
	},
	items : [{
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
		itemId : 'courseSessionDocumentNameField',
		name : 'name',
		allowBlank : false,
		maxLength: 50,
		vtype : 'NospaceAsInput'
	}, {
		xtype : 'filefield',
		ui : 'CustomBtnSubmit',
		fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
		buttonText : getPersonModuleTranslation('UPLOAD'),
		itemId : 'courseSessionUploadFileField',
		name : 'file',
		allowBlank:false,
		//validateOnChange : true,
		/*listeners:{
			change: function(field, val) { 
                var fileName = /^.*\.(exe)$/i;
                if(fileName.test(val)){
                	field.reset();
                	showWarningMessage(getCommonTranslation('UPLOAD_DOCUMENT'),getCommonTranslation('CANNOT_UPLOAD_EXE_FILE'));
                	return false;
                }
          }
		}*/
		 listeners: {
			 change: function(fileField, value, eOpts){
                	if(!isNullOrEmpty(fileField.fileInputEl.dom.files[0])) {
                		//var $this = this;
                		var $this = fileField.up('form');
                    	value = value.replace('C:\\fakepath\\', '');
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	fileField.setRawValue(newValue);
                    	if (!isNullOrEmpty(newValue)) {
                    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    	    if ($this.isValidFileExtensionForCourseSessionDiary(extension)) {
                    	        var file = fileField.fileInputEl.dom.files[0];
                    	        var fileSizeInMB = file.size / (1024 * 1024);
                    	        var fileSizeLimit = CONSTANTS.UPLOAD_FILE_SIZE_LIMIT_FOR_COURSE_SESSION;
                    	        if (fileSizeInMB > fileSizeLimit) {
                    	            fileField.reset();
                    	            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_TENMB'));
                    	        }
                    	    } else {
                    	        fileField.reset();
                    	        showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                    	    }
                    	}
            		}
                }
		    }
	},{
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('FILES_NAMES'),
		itemId : 'existingFile',
		name : 'files',
		allowBlank : true,
		readOnly : true,
		hidden: true
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		itemId:'containerIdForButtons',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'courseSessionDocumentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'courseSessionDocumentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE,
			handler : function(){
				if(Ext.isDefined(this.up('window'))){
					this.up('window').close();	
				}
			}

		} ]
	}]
});
