/**
 * This view is used for simple url form
 * @author Harshit Patidar
 */
Ext.define('Academia.view.document.SimpleUrlForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.simpleurlform',
	autoScroll : false,
	plugins: "formlabelrequired",
	defaults : {
		labelAlign:'top',
		width: 226
	},
	items : [{
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
		itemId : 'documentNameField',
		name : 'name',
		maxLength: 50,
		vtype : 'NospaceAsInput',
	}, {
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('DOCUMENTS_URL'),
		itemId : 'documentUrlField',
		name : 'urlname',
		allowBlank : false,
		maxLength: 2048,
		allowBlank: false,
		vtype : 'NospaceAsInput'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		itemId:'containerIdForButtons',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'documentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'documentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE,
			handler : function(){
				if(Ext.isDefined(this.up('window'))){
					this.up('window').close();	
				}
			}

		} ]
	} ]
});
