/**
 * @author Sachin.Bangar
 * This is dynamic template content 
 */
Ext.define('Academia.view.documentmanagement.DynamicTemplateDataForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.dynamictemplatedataform',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 350
        },
        style :{
         	marginLeft : '17px',
         	marginTop : '19px'
         },
        items: [{
            xtype: 'customcombobox',
            matchFieldWidth: true,
            fieldLabel: getDocumentTranslation('SELECT_PROPERTY'),
            editable: false,
            name: 'SELECT_PROPERTY',        
            submitValue: false,
            itemId: 'templatePropertyCombo',
            valueField: 'placeHolder',
            queryMode: 'local',
            displayField: 'displayCode',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.documentmanagement.DynamicTemplateDataStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style :{
         	marginLeft : '17px',
         	marginTop : '19px'
         },
        items: [{
            xtype: 'button',
            text: getDocumentTranslation('ADD_TO_TEMPLATE'),
            itemId: 'saveTemplateButton',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});