/**
 * Gajendra.verma
 */
Ext.define('Academia.view.enquiry.CommunicationHistory.CommunicationHistoryFilter', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.communicationhistoryfilter',
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'panel',
        items: [{
            xtype: 'panel',
            cls: 'customSearchPanel',
            items: [{
                xtype: 'radiogroup',
                itemId: 'sendmessageId',
                labelAlign: 'top',
                allowBlank: false,
                fieldLabel: getMessagingModuleTranslation('SENT_MESSAGES'),
                items: [{
                    boxLabel: getMessagingModuleTranslation('EMAIL'),
                    name: 'sendMessage',
                    inputValue: 1,
                    checked: true
                }, {
                    boxLabel: getMessagingModuleTranslation('SMS'),
                    name: 'sendMessage',
                    inputValue: 2
                }]
            }, {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
        			width: 226
                },
                items: [{
                	xtype: 'customcombobox',
                	//disabled: true,
                	name: 'recipientName',
                	itemId: 'recipientName',
                	fieldLabel: getMessagingModuleTranslation('RECIPIENT_NAME'),
                	displayField: 'value',
                	valueField: 'value',
                	queryParam: 'query',
                	minChars: 3,
                	forceSelection: true,
                	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                	listeners: {
                		render: function(combo) {
                			var store = Ext.create('Academia.store.enquiry.communicationhistorystore.CommunicationHistoryNameStore');
                			combo.bindStore(store);
                		}
                	},
                	listConfig: {
                		listeners: {
                			beforeshow: function(picker) {
                				picker.minWidth = picker.up('combobox').getSize().width;
                			}
                		},
                		loadingText: getCommonTranslation('SEARCHING'),
                		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                		getInnerTpl: function() {
                			return '<div class="search-item">' +
                			'{code}' +
                			'</div>';
                		}
                	}
                }, {
                    xtype: 'customcombobox',
                    name: 'emailId',
                    itemId: 'emailId',
                    fieldLabel: getMessagingModuleTranslation('EMAIL'),
                    displayField: 'primaryeEmailId',
                    valueField: 'primaryeEmailId',
                    editable: false,
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.enquiry.communicationhistorystore.CommunicationHistoryContactStore');
                            combo.bindStore(store);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'mobileId',
                    itemId: 'mobileId',
                    fieldLabel: getMessagingModuleTranslation('MOBILE_NO'),
                    displayField: 'phoneNo',
                    valueField: 'phoneNo',
                    vtype: 'numericValueValidation',
                    hidden: true,
                    editable: false,
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.enquiry.communicationhistorystore.CommunicationHistoryContactStore');
                            combo.bindStore(store);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'sentby',
                    itemId: 'sentby',
                    store: 'criteriabuilder.userquicksearch.QuickSearchPrintNameStore',
                    fieldLabel: getMessagingModuleTranslation('SENT_BY'),
                    displayField: 'valueCode',
                    valueField: 'id',
                    queryParam: 'printName',
                    minChars: 3,
                    typeAhead: false,
        			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        			triggerAction: '',
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    forceSelection: true
                }]
            }, {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
        			width: 226
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'eventName',
                    itemId: 'eventName',
                    store: 'messaging.SendMessageReportEventNameStore',
                    fieldLabel: getMessagingModuleTranslation('EVENT_NAME'),
                    displayField: 'uiDisplayCode',
                    valueField: 'uiDisplayCode',
                    queryParam: 'eventName',
                    minChars: 3,
                    typeAhead: false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    forceSelection: true,
                    listConfig: {
                        listeners: {
                            beforeshow: function(picker) {
                                picker.minWidth = picker.up('combobox').getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    }
                }, {
                    xtype: 'datefield',
                    name: 'eventDateForm',
                    itemId: 'eventDateForm',
                    fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE'),
                    vtype: 'daterange',
                    endDateField: 'eventDateTill',
                    editable: false,
                    listeners: {
                        render: function(field) {
                            return dateFormatRender(field);
                        }
                    },

                }, {
                    xtype: 'datefield',
                    name: 'eventDateTill',
                    itemId: 'eventDateTill',
                    fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE'),
                    vtype: 'daterange',
                    startDateField: 'eventDateForm',
                    editable: false,
                    listeners: {
                        render: function(field) {
                            return dateFormatRender(field);
                        }
                    }
                }]
            }, {
                xtype: 'fieldcontainer',
                width: '100%',
                items: [{
                    xtype: 'button',
                    text: getMessagingModuleTranslation('SEARCH'),
                    itemId: 'searchButtonId',
                    buttonAlign: 'right',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE
                }, {
                    xtype: 'button',
                    text: getMessagingModuleTranslation('CLEAR_SEARCH'),
                    itemId: 'resetButtonId',
                    buttonAlign: 'right',
                    hidden: false,
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE
                }]
            }]
        }]
    }]
});