var enquiryGridStore = Ext.create('Academia.store.enquiry.EnquiryGridStore');
Ext.define('Academia.view.enquiry.EnquiryGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.enquirygrid',
    store : enquiryGridStore,
	title : getEnquiryTranslation('ENQUIRY_STUDENT_DETAILS_GRID_HEADER'),
	hidden:true,
	border : true,
	autoScroll : false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable : true,
	enableColumnHide: false,
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},
	{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},
	{
			xtype : 'button',				
			itemId : 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip :getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
	}
	],
	columns : [{
		header : getCommonTranslation('TRACK_ENQUIRER_STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	}, {
	    header : getCommonTranslation('ACADEMY'),
	    dataIndex : 'academy',
	    sortable : true,
	    flex : 1
	}, {
	    header : getCommonTranslation('LOCATION'),
	    dataIndex : 'location',
	    sortable : true,
	    flex : 1
	}, {
	    header : getCommonTranslation('PROGRAM_GROUP'),
//	    translationKey: 'PROGRAM',
	    dataIndex : 'programGroupName',
	    sortable : true,
	    hidden:true,
	    flex : 1
	},{
	    header : getCommonTranslation('PROGRAM'),
//	    translationKey: 'PROGRAM',
	    dataIndex : 'program',
	    sortable : true,
	    flex : 1
	}, {
	    header : getCommonTranslation('ACADEMIC_BATCH'),
	    dataIndex : 'batchName',
	    flex : 1
	},{
	    header : getCommonTranslation('SEAT_TYPE'),
	    dataIndex : 'seatType',
	    flex : 1
	},{
		header : getCommonTranslation('MODE_OF_DELIVERY'),
		hidden:true,
		dataIndex : 'modeofDeliveryCSM',
	},{
		header : getCommonTranslation('REGISTRATION_TYPE'),
		hidden:true,
		dataIndex : 'registrationTypeCSM'
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		hidden:true,
	    dataIndex : 'studentFname'
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		hidden:true,
	    dataIndex : 'studentMname'
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		hidden:true,
	    dataIndex : 'studentLname'
	},{
		header : getCommonTranslation('DOB_OF_STUDENT'),
		dataIndex : 'studentDateOfBirth',
		hidden:true,
		renderer:function(val){		
			return dateRender(val);
		}
	},/*{
		hidden:true,
	    dataIndex : 'academyId'
	},{
		hidden:true,
	    dataIndex : 'locationId'
	},{
		hidden:true,
	    dataIndex : 'programId'
	},{
		hidden:true,
	    dataIndex : 'batchId'
	},{
		hidden:true,
	    dataIndex : 'seatTypeId'
	}  	*/
	
	/*, {
	    header : "Status",
	    dataIndex : 'status',
	    renderer : function(value) {
		if (value) {
		    return value = 'Active';
		} else {
		    return value = 'Inactive';
		}
		console.log(value);
	    }
	} */]

});