/**
 * Rajkumar
 */
Ext.define('Academia.view.enquiry.TrackEnquiryGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.trackenquirygrid',
	store : 'enquiry.TrackEnquiryStore',
	title : getCommonTranslation('TITLE_GRID'),
	border: true,
	sortableColumns:true,
	enableColumnHide: true,
	enableColumnMove: true,
	enableColumnResize: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
			store:'enquiry.TrackEnquiryStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],

	columns : [{
		header : getCommonTranslation('TRACK_ENQUIRY_CAMPAIGN_ID'),
		dataIndex : 'campaign',
		flex : 0.9,
		renderer:function(value) {
			if(value!=null){
				return value.code;
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('TRACK_ENQUIRY_CAMPAIGN_NAME'),
		dataIndex : 'campaign',
		flex : 1.2,
		renderer:function(value) {
			if(value!=null){
				return value.value;
			}else{
				return value;
			}

		}
	},{
		header : getCommonTranslation('TRACK_ENQUIRY_NO'),
		dataIndex : 'id',
		flex : 1,
		renderer:function(value){
			return  '<a  id:tab1, href="#">ENQ-'+value+'</a>';
		}
	},{
		header : getCommonTranslation('ENQUIRY_TYPE_1'),
		dataIndex:'enquiryType',
		flex : 1,
		renderer:function(value) {
			if(value!=null){
				return value.value;
			}else{
				return value;
			}

		}
	},{
		header : getCommonTranslation('TRACK_ENQUIRER_NAME'),
		dataIndex : 'user',
		flex : 1.2,
		renderer:function(value) {
			if(value!=null){
				return value.value;
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('TRACK_ENQUIRY_DATE'),
		dataIndex:'enquiryDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:getCommonTranslation('EMPLOYEE_NAME'),
		hidden:true,
		dataIndex:'employeeName',
		flex : 1
	},{
		header:getCommonTranslation('TRACK_ENQUIRY_STATUS'),
		dataIndex:'status',
		flex : 1,
		renderer:function(value) {
			if(value==0){
				return getCommonTranslation('CLOSE');
			}else{
				return getCommonTranslation('OPEN');	
			}
		}
	},{
		header:getCommonTranslation('TRACK_ENQUIRY_NO_OF_FOLLOWUP'),
		dataIndex:'noOfFollowUps',
		flex : 1
	},{
		header:getCommonTranslation('TRACK_ENQUIRY_TIME_COMPLETION'),
		dataIndex:'followUpDate',
		flex : 1,
		renderer:function(value, meta, record, rowIndex) {
			var FD = value;
			var ED = record.data.enquiryDate;
			var one_day=1000*60*60*24; 
			var x=FD.split("-");     
			var y=ED.split("-");
			var date1=new Date(x[2],(x[1]-1),x[0]);  
			var date2=new Date(y[2],(y[1]-1),y[0]);
			var times =  Math.abs((date1.getTime()-date2.getTime())/(one_day)); 
			return times;
		}
	},{
		header : getCommonTranslation('TRACK_ENQUIRER_STUDENT_NAME'),
		dataIndex : 'enquiryStudentDetails',
		flex : 1.2,
		renderer:function(value) {
			if(value[0]!=null){
				var name = value[0].studentFirstName+" "+value[0].studentLastName;
				return name;
			}else{
				return '';
			}


		}
	},{
		header : getCommonTranslation('ACADEMY'),
		dataIndex:'enquiryStudentDetails',
		flex : 1,
		renderer:function(value){	
			if(value[0]!=null){
				var academy = '';
				Ext.each(value[0].admissionEnquiryDetails, function(academyVal) {
					var aName =  '<li>'+academyVal.academy.value+'<br>'+'<br>';
					academy = academy + aName;
				});
				return academy;
			}else{
				return '';
			}

		} 
	},{
		header:getCommonTranslation('LOCATION_NAME'),
		dataIndex:'enquiryStudentDetails',
		flex : 1,
		renderer:function(value){	
			if(value[0]!=null){
				var location = '';
				Ext.each(value[0].admissionEnquiryDetails, function(locationVal) {
					var lName =  '<li>'+locationVal.location.value+'<br>'+'<br>';
					location = location + lName;
				});
				return location;
			}else{
				return '';
			}

		}
	}],
	listeners: {
		cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
			if(e.target.tagName=='A'){
				this.fireEvent('edit',view,rowIndex);	
			}
		}
	}

});