/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.eventmeetingminutes.EventMeetingMinutesForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.eventmeetingminutesform',
    title: getServiceRequestTranslation('EMM_ADD_MINUTES'),
    frame: true,
    plugins: "formlabelrequired",
    border: false,
    autoScroll: false,
    itemId: 'eventmeetingminutesformItemId',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'hidden',
            name: 'id',
            itemId: 'idItemId'
        }, {
            xtype: 'hidden',
            name: 'eventId',
            itemId: 'eventIdItemId'
        }, {
            xtype: 'textfield',
            name: 'eventName',
            itemId: 'eventNameItemId',
            fieldLabel: getServiceRequestTranslation('EVENT_NAME'),
            maxLength: 100,
            readOnly: true
        }, {
            xtype: 'textfield',
            name: 'bookedBy',
            itemId: 'bookedByItemId',
            fieldLabel: getCommonTranslation('BOOKED_BY'),
            maxLength: 50,
            readOnly: true
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'minuteTakerId',
            itemId: 'minuteTakerIdItemId',
            fieldLabel: getServiceRequestTranslation('EMM_MINUTE_TAKER'),
            store: 'eventmeetingminutes.EventMeetingMinutesParticipantStore',
            valueField: 'id',
            displayField: 'codePrintName',
            queryParam: 'codeOrName',
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            //triggerAction: '',
            hideTrigger: false,
            allowBlank: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'datefield',
            name: 'minuteDate',
            itemId: 'minuteDateItemId',
            fieldLabel: getCommonTranslation('DATE'),
            allowBlank: false,
            vtype: 'daterange',
            maxValue: new Date(),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
                render: function(obj) {
                    obj = dateFormatRender(obj);
                    obj.setValue(new Date());
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            name: 'minuteSubject',
            itemId: 'minuteSubjectItemId',
            fieldLabel: getServiceRequestTranslation('EMM_MINUTE_SUBJECT'),
            maxLength: 100,
            allowBlank: false,
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('EMM_VIEW_PARTICIPANTS'),
            itemId: 'viewParticipantsEventmeetingminutesformItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            style: {
                //marginLeft: '-2px',
                marginTop: '30px'
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'importFieldContainerItemId',
        defaults: {
            /*labelAlign: 'top',
            width: 226*/
        },
        style: {
            marginTop: '10px',
        },
        items: [{
            xtype: 'checkboxfield',
            name: 'importPreviousMeetingMinutes',
            itemId: 'importPreviousMeetingMinutesItemId',
            boxLabel: getServiceRequestTranslation('EMM_IMPORT_PREVIOUS_MEETING_MINUTES'),
            width: 'auto',
            labelAlign: 'right',
            /*style: {
            	marginTop: '25px',
            	marginLeft: '10px'
            },*/
            inputValue: true,
            uncheckedValue: false
        }, {
            xtype: 'customcombobox',
            name: 'previousMinuteId',
            itemId: 'previousMinuteIdItemId',
            store: 'eventmeetingminutes.EMMPreviousMinuteStore',
            valueField: 'id',
            displayField: 'minuteDateInOrgFormat',
            typeAhead: false,
            forceSelection: true,
            editable: false,
            width: 226,
            disabled: true,
            style: {
                //marginTop: '25px',
                marginLeft: '5px'
            },
            maxLength: 130
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('EMM_IMPORT'),
            itemId: 'importEventmeetingminutesformItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            disabled: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
        xtype: 'eventmeetingminutestaskgrid',
        style: {
            marginLeft: '0px',
            marginTop: '30px'
        }
    },{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		}, style: {
           // marginLeft: '0px',
            marginTop: '-20px'
        },
		items: [{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getServiceRequestTranslation('FD_UPLOAD_DOCUMENT')+'</b>',
			style: {
				textDecoration: "underline"
			}
		}]
	}, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'eventmeetingminutesdocumentgrid',
            itemId: 'eventmeetingminutesdocumentgridItemId',
            style: {
                marginLeft: '0px'
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            itemId: 'saveEventmeetingminutesformItemId',
            formBind: true,
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetEventmeetingminutesformItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('UPLOAD_DOC'),
            itemId: 'eventmeetingminuteDocumentUploadId',
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});