/**
 * Ashutosh.Bhawsar
 */
var examStore=Ext.create('Academia.store.examcancellation.ExamCancellationGridStore');
Ext.define('Academia.view.examcancellation.ExamCancellationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.examcancellationgrid',
	store: examStore,
	border: true,
	frame:false,
	title:getCommonTranslation('LIST_OF_EXAM_CANCELLATION'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				itemId:'managePaggingToolBarItemId',
				plugins:['pagesize'],
			    store : examStore,
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],
   isGridConfigurable:true,
   enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
 },
 tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
       xtype: 'button',
       itemId: 'btnApplyTo',
       tooltip: getCommonTranslation('APPLY_TO'),
       text: getCommonTranslation('APPLY_TO'),
       disabled: true
   }],
 	
	columns: [{
		header: getCommonTranslation('EXAM_CANCELLATION_NAME'),
		dataIndex: 'examCancellationName',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:.4,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.status)) {
				return getCommonTranslation(record.data.status);
			}                        
		}
	},{
		header: getCommonTranslation('MAX_COURSE_APPLICABLE'),
		dataIndex: 'maximumCourse',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('MAPPED_PROGRAMS'),
		dataIndex: 'mappedPrograms',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val=='0' || val == '0.00' || val == '0.0'){
    				return "-";
    			}else{
    				return "<a href='#'>"+val+"</a>" ;
    			}
    		} else {
    			return "-";
    		}
    	},
	},{
		header : getCommonTranslation('REQUEST_RECEIVED'),
		dataIndex : 'requestReceived',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val=='0' || val == '0.00' || val == '0.0'){
    				return "-";
    			}else{
    				return "<a href='#'>"+val+"</a>" ;
    			}
    		} else {
    			return "-";
    		}
    	}
	},{
		header : getCommonTranslation('REQUEST_APPROVED'),
		dataIndex : 'requestApproved',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val=='0' || val == '0.00' || val == '0.0'){
    				return "-";
    			}else{
    				return "<a href='#'>"+val+"</a>" ;
    			}
    		} else {
    			return "-";
    		}
    	}
	}]
});
