/**
 * Document Submitted – grid with pagination
 */
Ext.define('Academia.view.examexecution.DocumentSubmittedWindow', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.documentsubmittedwindow',

    layout: 'fit',
    bodyPadding: 10,

    initComponent: function () {
        var me = this;

        var docStore = Ext.create('Ext.data.Store', {
            autoLoad: true,
            pageSize: 25,
            fields: [
                'documentName',
                'date',
                'electronicDocument',
                'inspectionRequired',
                'inspectionDoneBy',
                'returnableDocument',
                'returnBy',
                'downloadLink'
            ],
            proxy: {
                type: 'ajax',
                url: '/api/document-submitted/list', // <— replace with real API
                reader: { type: 'json', rootProperty: 'data', totalProperty: 'total' }
            }
        });

        Ext.apply(me, {
            items: [{
                xtype: 'grid',
                itemId: 'documentSubmittedGrid',
                border: true,
                columnLines: true,
                store: docStore,
                title: '<div style="text-align:center;font-weight:bold;">' +
                       getMegaMenuTranslation('DOCUMENT_LIST') + '</div>',
                columns: [
                    { text: 'Document Name', dataIndex: 'documentName', flex: 1 },
                    { text: 'Date', dataIndex: 'date', flex: 1 },
                    { text: 'Electronic Document', dataIndex: 'electronicDocument', flex: 1 },
                    { text: 'Inspection Required', dataIndex: 'inspectionRequired', flex: 1 },
                    { text: 'Inspection Done By', dataIndex: 'inspectionDoneBy', flex: 1 },
                    { text: 'Returnable Document', dataIndex: 'returnableDocument', flex: 1 },
                    { text: 'Return By', dataIndex: 'returnBy', flex: 1 },
                    {
                        text: 'Download',
                        dataIndex: 'downloadLink',
                        flex: 1,
                        renderer: function (v, m, rec) {
                            return v ? '<a href="' + v + '" target="_blank" style="text-decoration:underline;">' +
                                   (rec.get('documentName') || getCommonTranslation('DOWNLOAD')) + '</a>' : '';
                        }
                    }
                ],
                bbar: {
                    xtype: 'pagingtoolbar',
                    store: docStore,
                    displayInfo: true,
                    displayMsg: 'Showing documents {0} - {1} of {2}',
                    emptyMsg: getCommonTranslation('NO_DOCUMENTS')
                }
            }]
        });

        me.callParent(arguments);
    }
});