
/**

 * @author 
 * Vinay Kumrawat
 *
 */
Ext.define('Academia.view.examinationattendancerule.EventLevelRemarkAddForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.eventlevelremarkaddform',
	autoScroll:true,
	layout: 'vbox',
	defaults : {
		labelAlign : 'top',
		width : 250 
	},
	plugins : "formlabelrequired",
	items : [{ 
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {  
			labelAlign : 'top',
			width : 270
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'textfield',
			name : 'remarkCode',
			itemId: 'remarkCodeId',
			allowBlank : false,
			fieldLabel : getExaminationTranslation('REMARK_CODE'),
			readOnly: false,
			maxLength:55, 
			validator: function(value) {
				if(!isNullOrEmpty(value)){ 
			    var alphaNumericRegex =/^(?!\s+$)[a-zA-Z0-9\s]+$/; 
			    if (!alphaNumericRegex.test(value)) {
			        return 'Invalid Selection';     
			    }return true;}}
		},
		{
			xtype : 'textfield',
			name : 'remarkName',
			itemId: 'remarkNameId',
			allowBlank : false,
			fieldLabel : getExaminationTranslation('REMARK_NAME'),
			readOnly: false,
			maxLength:255,
			enterIsSpecial:true,
			validator: function(value) {		// (,.!'@&*|;")
				var validChars=/^[a-zA-Z0-9\s\-\.\,\!\@\&\*\|\;\'\"\(\)]*$/;   
					if(!isNullOrEmpty(value)&&!validChars.test(value)){           
						return 'Invalid Selection';     
					}else{return true ; }}  
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 270
		},
		layout : {
			type : 'hbox'
		},
		items : [{  
			xtype : 'textfield',
			name : 'reamrkDesc',
			itemId: 'reamrkDesc', 
			allowBlank :true, 
			fieldLabel : getExaminationTranslation('REMARK_DESC'),
			maxLength:255,
			enterIsSpecial:true,
			validator: function(value) {
				var validChars=/^[a-zA-Z0-9\s\-\.\,\!\@\&\*\|\;\'\"\(\)]*$/;         
					if(!isNullOrEmpty(value)&&!validChars.test(value)){            
						return 'Invalid Selection';     
					}else{return true ; }} 
		},{
        		xtype: 'customcombobox',
        		width:270,   
				name:'studentStatus',
				itemId:'studentStatus',
				fieldLabel: getCommonTranslation('STATUS'),
				minChars:3,
				typeAhead:false,
				editable: false,
				value:true,
				valueField: 'value',
                displayField: 'name',
				forceSelection:true, 
				store:'common.picklist.StudentActiveInactiveStatusStoreForMarkSheet', 
				disabled:false,
				allowBlank :false,   
        	}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 270
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype: 'radiogroup',  
			fieldLabel : getExaminationTranslation('PUBLISH_MARKS_ON_STDUENT_PORTAL'),
            name: 'publishmarksonstudentportal',
            itemId: 'publishmarksonstudentportalId',
            maxLength:255,
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'ispublishmarksonstudentportalId',
				inputValue : true
				}, {
				boxLabel : getExaminationTranslation('NO'),
				name : 'ispublishmarksonstudentportalId', 
				inputValue : false,
				checked : true
			} ],
		},{   
			xtype: 'radiogroup',  
			fieldLabel : getExaminationTranslation('PUBLISH_REMARKS_ON_STDUENT_PORTAL'),
            name: 'publishremarkStportal',
            itemId: 'publishremarkStportalId', 
            maxLength:255,
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'ispublishremarkStportalId',
				inputValue : true,
				checked : true

			}, {
				boxLabel : getExaminationTranslation('NO'),
				name : 'ispublishremarkStportalId',     
				inputValue : false 
			} ],
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 270
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype: 'radiogroup',  
			fieldLabel : getExaminationTranslation('PUBLISH_MARKS_ON_MARKSHEET'),
            name: 'publishmarksonmarksheet',
            itemId: 'publishmarksonmarksheetId',
            maxLength:255,
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'ispublishmarksonmarksheetId',
				inputValue : true},  
				{
				boxLabel : getExaminationTranslation('NO'),
				name : 'ispublishmarksonmarksheetId', 
				inputValue : false,
				checked : true
			} ],
		},{
			xtype: 'radiogroup',  
			fieldLabel : getExaminationTranslation('PUBLISH_REMARKS_ON_MARKSHEET'),
            name: 'publishremarksonmarksheet',
            itemId: 'publishremarksonmarksheetId',
            maxLength:255,
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'ispublishremarksonmarksheetId',
				inputValue : true,
				checked : true

			}, {
				boxLabel : getExaminationTranslation('NO'),
				name : 'ispublishremarksonmarksheetId',  
				inputValue : false 
			} ],
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 270
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype: 'radiogroup',  
			fieldLabel : getExaminationTranslation('ALLOW_TO_ENTER_FROM_FACULTY_PORTAL'),
            name: 'whetherAccessToFaculty',
            itemId: 'whetherAccessToFacultyId',
            maxLength:255,
            defaults: {
				flex: 1
			},
			layout: 'hbox',
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name : 'whetherAccessToFacultyId',
				inputValue : true,
				checked : true
				}, 
				 
				{
				boxLabel : getExaminationTranslation('NO'),
				name : 'whetherAccessToFacultyId', 
				inputValue : false
				
			} ],
		}]
	}, {
		xtype : 'fieldcontainer',
		width : '100%', 
		cls : 'windowBtnPos', 
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'remarksSubmitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true  
		}, {
    		xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		itemId: 'remarksResetBtn',
    		buttonAlign: 'right',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE,
    		listeners: {
    			click: function(button, eOpts) {  
    				this.up('form').getForm().reset();
    			}
    		}
    	},{
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		itemId: 'cancleBtn',
    		buttonAlign: 'right',
    		ui: 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE,
			hidden: true,
			listeners:{
                click : function(btn){
                    btn.up('window').close();
                },
         },
    	}]
	} ]
});