/**
 * Abhishek Soni
 */
var examCenterStore = Ext.create('Academia.store.examCenter.ExamCenterStore');

Ext.define('Academia.view.examinationcenters.ExaminationCenterGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.examinationcentergrid',
	store:examCenterStore,
	frame: false,
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'examinationcentersearchtab': 1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  examCenterStore,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'examCenterAddBtn',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'examCenterEditdBtn',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'examCenterViewBtn',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype : 'splitbutton',
		itemId:'spBtnMoreActionsAssessmentEvent',
		text : getExaminationTranslation('MOREACTIONS'),
		menu:[{
			text:getExaminationTranslation('DISABLE'),
			tooltip: getExaminationTranslation('DISABLE'),
			itemId:'examCenterDeleteBtn'	
		}]
	}],
	columns: [{
		header: getCommonTranslation('ID'),
		dataIndex: 'id',
		flex: .1,
		hidden:true
	}, {
		header: getCommonTranslation('CENTER'),
		dataIndex: 'centreCode',
		flex: .1
	}, {
		header: getCommonTranslation('CENTER_TYPE'),
		dataIndex: 'centerType',
		flex: .1
	}, {
		header: getCommonTranslation('ADDRESS_CITY'),
		dataIndex: 'cityName',
		flex: .1
	}, {
		header: getCommonTranslation('CENTER_SUPERVISOR'),
		dataIndex: 'centerSupervisionName',
		flex: .1
	}, {
		header: getCommonTranslation('ADDRESS'),
		dataIndex: 'addressText',
		flex: .1
	}, {
		header: getCommonTranslation('CENTER_CAPACITY'),
		dataIndex: 'centerType',
		flex: .1
	}, {
		header: getCommonTranslation('ALLOW_ALLOCATION_BY_SUPERVISOR'),
		dataIndex: 'allowAllocationBySupervisor',
		flex: .1,
		renderer:function(value){
			if(value){ return "YES"; }else { return "NO" };
		},
		hidden:true
	}, {
		header: getCommonTranslation('CENTER_STATUS'),
		dataIndex: 'whetherActive',
		flex: .1,
		renderer:function(value){
			if(value){ return getExaminationTranslation("CNTRL_ACTIVE"); }
			else { return getExaminationTranslation("CNTRL_INACTIVE"); };
		}
	}]
});