/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.RoomDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.roomdetailsgrid',
    store : 'examinationcenters.RoomGridBlank',
    title : getExaminationTranslation('ROOM_DETAILS')+'<span class="required" style="color:red"> *</span>',
    border: true,
    autoScroll: false,
    frame:false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
	        header:'ID',
	        dataIndex : 'id',
	        hidden:true
    	},{
		  	header : getExaminationTranslation('ROOM_NUMBER'),
		  	dataIndex : 'roomNumber',
		  	flex:1
       },{
            header : getExaminationTranslation('ROOM_LOCATION'),
	        dataIndex : 'roomLocation', 
	        flex:1
       },{
            header : getExaminationTranslation('ROOM_CAPACITY'),
	        dataIndex : 'roomCapacity',
	        flex:1
	    }]
});