/**
 * @Abhishek Chouhan
 * 
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.ManageHierarchyStatusForm', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.managehierarchystatusform',
	modal:true,
	autoScroll:false,
	items: [{
		xtype:'form',
		itemId:'hierarchyStatusFormId',
		items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'programName',
				fieldLabel:'<b>'+getExaminationTranslation('PROGRAM')+'</b>'
			},{
				xtype:'displayfield',
				name:'batchName',
				fieldLabel:'<b>'+getExaminationTranslation('BATCH')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'course',
				fieldLabel:'<b>'+getExaminationTranslation('COURSE')+'</b>'
			},{
				xtype:'displayfield',
				name:'evaluationPlanName',
				fieldLabel:'<b>'+getExaminationTranslation('EVALUATION_PLAN')+'</b>'
			},{
				xtype:'hidden',
				name:'evaluationPlanId',
				itemId: 'evaluationPlanId',
			},{
				xtype:'hidden',
				name:'programId',
				itemId: 'programId',
			},{
				xtype:'hidden',
				name:'batchId',
				itemId: 'batchId',
			},{
				xtype:'hidden',
				name:'periodId',
				itemId: 'periodId',
			},{
				xtype:'hidden',
				name:'courseId',
				itemId: 'courseId',
			}]
		}]
	},{
		xtype: 'grid',
		itemId:'manageHierarchyStatusGrid',//'ManageEval',
		frame:false,
		border:true,
		autoScroll:true,
		//hidden: true,
		store:Ext.create('Academia.store.examinationcenters.evaluationplanstatus.EvaluationStatusGridStore'),
		//selType:'checkboxmodel',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getExaminationTranslation('UPDATE_HIERARCHY_STATUS'),
					itemId: 'updateHierarchyStatus',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
				}]
		}],
		columns: [ {
	         header: getExaminationTranslation('EVALUATION_TYPE'),
	         dataIndex: 'type',
	         flex:.1,
	         sortable: true
	      },{
	          header: getExaminationTranslation('EVALUATION_TYPE_STATUS'),
	          dataIndex: 'typeStatus',
	          flex:.1,
	          sortable: true,
	         // hidden:true,
	          renderer:function(value){
		    	  if(value=="PENDING"){
		    		  return "Pending";
		    		  
		    	  }else if(value=="CLOSED"){
		    		  return "Closed";
		    		  
		    	  }else if(value=="COMPLETED"){
		    		  return "Completed";
		    		  
		    	  }else if(value=="CONDUCTED"){
		    		  return "Conducted";
		    		  
		    	  }else{
		    		  return value;
		    	  }
		      }
	       },{
	        header: getExaminationTranslation('EVALUATION_SUB_TYPE'),
	        dataIndex: 'subType',
	        flex:.1,
	        sortable:true
	      },{
	          header: getExaminationTranslation('EVALUATION_SUB_TYPE_STATUS'),
	          dataIndex: 'subTypeStatus',
	          flex:.1,
	          sortable: true,
	         // hidden:true,
	          renderer:function(value){
		    	  if(value=="PENDING"){
		    		  return "Pending";
		    		  
		    	  }else if(value=="CLOSED"){
		    		  return "Closed";
		    		  
		    	  }else if(value=="COMPLETED"){
		    		  return "Completed";
		    		  
		    	  }else if(value=="CONDUCTED"){
		    		  return "Conducted";
		    		  
		    	  }else{
		    		  return value;
		    	  }
		      }
	       },{
	        header: getExaminationTranslation('EVALUATION_METHOD_VALUE'),
	        dataIndex: 'method',
	        flex:.1,
	        sortable:true
	      },{
	          header: getExaminationTranslation('EVALUATION_METHOD_VALUE_STATUS'),
	          dataIndex: 'methodStatus',
	          flex:.1,
	          sortable: true,
	          //hidden:true,
	          renderer:function(value){
		    	  if(value=="PENDING"){
		    		  return "Pending";
		    		  
		    	  }else if(value=="CLOSED"){
		    		  return "Closed";
		    		  
		    	  }else if(value=="COMPLETED"){
		    		  return "Completed";
		    		  
		    	  }else if(value=="CONDUCTED"){
		    		  return "Conducted";
		    		  
		    	  }else{
		    		  return value;
		    	  }
		      }
	       }]
	}]
});