var calculateAverageYearlyStore =Ext.create('Academia.store.examinationcenters.calculateAverage.CalculateAverageYearlyGridStore');
Ext.define('Academia.view.examinationcenters.calculateAverage.CalculateAverageYearlyGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.calculateaverageyearlygrid',
	store: calculateAverageYearlyStore,
	border: true,
	frame:false,
	selType:'checkboxmodel',
	title:getExaminationTranslation('LIST_OF_STUDENTS'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		showHeaderCheckbox: true,
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false
	},
	isGridConfigurable:true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		width : 'auto',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top'
		},
		items:[ {
			xtype: 'button',
			text:getExaminationTranslation('CALCULATE_AVERAGE_YEARLY'),
			itemId:'caclulateAverageYearlyBtnId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			tooltip: getExaminationTranslation('CALCULATE_AVERAGE_YEARLY'),
			disabled: true
		}, {
			xtype: 'button',
			text:getExaminationTranslation('CALCULATE_PROG_AVERAGE'),
			itemId:'caclulateProgAverageYearlyBtnId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			tooltip: getExaminationTranslation('CALCULATE_PROG_AVERAGE'),
			disabled: true
		}, {
			xtype: 'button',
			text:getExaminationTranslation('DELETE'),
			itemId:'deleteButtonId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			tooltip: getExaminationTranslation('DELETE'),
			disabled:true
		}]
	}],

	columns: [{
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.4,
		sortable:true
	},{
		header : getCommonTranslation('PERIOD_YEAR'),
		dataIndex : 'periodYearName',
		flex:.3,
		sortable: true
	},{
		header : getExaminationTranslation('YEARLY_AVERAGE'),
		dataIndex : 'yearlyAverage',
		flex:.3,
		sortable: true
	},{
		header : getExaminationTranslation('PROG_AVERAGE'),
		dataIndex : 'programAverage',
		flex:.3,
		sortable: true
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
	}]
});
