/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.centerunavailability.CenterUnavailabilityMasterGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.centerunavailabilitymastergrid',
    store: 'examinationcenters.centerunavailability.CenterUnavailabilityGridStore',
    border: true,
    autoScroll: false,
    frame:false,
    title:getExaminationTranslation('CENTER_UNAVAILABILITY_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.centerunavailability.CenterUnavailabilityGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    /*}, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'*/
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],
    columns: [{
        header: getExaminationTranslation('CENTER_NAME'),
        dataIndex: 'centerName',
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        flex:.3,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getExaminationTranslation('To_DATE'),
        dataIndex: 'toDate',
        flex:.3,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getExaminationTranslation('FROM_TIME'),
        dataIndex: 'fromTime',
        flex:.3,
        sortable: true,
        renderer:function(value){
        	return timeRender(value);
        }
    }, {
        header: getExaminationTranslation('TO_TIME'),
        dataIndex: 'toTime',
        flex:.3,
        sortable: true,
        renderer:function(value){
        	return timeRender(value);
        }
    /*}, {
        header: getExaminationTranslation('UNAVAILABILITY_STATUS'),
        dataIndex: 'reason',
        flex:.3,
        sortable: true*/
    }]
});