/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.detailsequencecovered.DetailSequenceCoveredGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.detailsequencecoveredgrid',
    store: 'examinationcenters.evaluationgroup.detailsequencecovered.DetailSequenceCovered',
    border: true,
    autoScroll: false,
    frame:false, 
    selType:'checkboxmodel',
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
    title:getExaminationTranslation('EVALUATION_EVENT_COVERED_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    listeners:{
    	beforeselect:function(selModel,record,index){
    		if(!isNullOrEmpty(selModel.view.up())){
    			var gridItemId = selModel.view.up().getItemId();
    			var grid = selModel.view.up();
    			
    			var evalGroupForm=this$.getContentpanel().getActiveTab().down('evalgroupdetailform');
    			var wetherEditableField=evalGroupForm.getForm().findField('wetherEditable').isEditable;

    			
	   			 if(wetherEditableField==false){
					 return false;
				 }
	   			 
    			var records=grid.getSelectionModel().getSelection();
    			if (records.length==0) {
					grid.down('#btnEdit').setDisabled(false);
				}else{
					grid.down('#btnEdit').setDisabled(true);
				}
    			

    			
    		}
    	},
    	deselect:function(selModel,record,index){
    		if(!isNullOrEmpty(selModel.view.up())){
    			var gridItemId = selModel.view.up().getItemId();
    			var grid = selModel.view.up();
    			var records=grid.getSelectionModel().getSelection();
    			if (records.length==1) {
					grid.down('#btnEdit').setDisabled(false);
				}else{
					grid.down('#btnEdit').setDisabled(true);
				}
    		}
    	}
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.evaluationgroup.detailsequencecovered.DetailSequenceCovered',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, 
    
    {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        disabled:true,
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },
    {
        xtype: 'button',
        itemId: 'autoExamSchedule',
        tooltip: getExaminationTranslation('AutoExamSchedule'),
        text: getExaminationTranslation('AutoExamSchedule'),

    },
    ],
    columns: [{
        header: getExaminationTranslation('EVALUATION_PLAN'),
        dataIndex: 'evaluationPlanNumber',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'courseCode',
        flex:.4,
        sortable:true,
        renderer:function(value,rec){
        	var data=rec.record.data;
        	if(data.courseCode!=null){
        		return data.courseCode;
        	}else if(data.externalCourseName!=null){
        		return data.externalCourseName;
        	}else if(data.categoryName!=null){
        		return data.categoryName;
        	}
        }
    }, {
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'programBatchName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('SECTION'),
        dataIndex: 'sectionName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'detailSequenceNumber',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('CENTER'),
        dataIndex: 'centerName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('DATE'),
        dataIndex: 'plannedDateStr',
        flex:.3,
        sortable: true,
        renderer:function(value,record) {
				if(record.record.data.plannedDateStr!=null){
						return value;
				}else{
					return "NA";
				}
		
		}
    }, {
        header: getExaminationTranslation('TIME_SLOT'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true,
        renderer:function(value, record){
				if(record.record.data.timeFromStr!=null){
					return (record.record.data.timeFromStr)+" - "+(record.record.data.timeToStr);					
				}else{
					return "NA";
				}
        }
    }, {
        header: getExaminationTranslation('VIEW_ASSIGNED_SEAT_TYPE'),
        dataIndex: 'view',
        flex:.3,
        sortable: true,
        renderer:function(){
        	return "<a href='#'>"+getExaminationTranslation('VIEW')+"</a>";
        }
    }]
});