/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.evaluationgroupdetail.DefineRulesWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.defineruleswindow',
    modal: true,
    autoScroll:true,
    title: getExaminationTranslation('DEFINE_RULES'),
    width: '40%',
    height:'83%',
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        //bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        
        items: [{
           	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    		items:[{
	    			 xtype: 'textfield',
				     name:'droolsRuleRanking',
				     fieldLabel: getExaminationTranslation('DROOL_RULE_FOR_RANKING'),
				     allowBlank: false
    		     },{
	    			 xtype: 'textarea',
				     name:'droolsRuleRankingDescription',
				     fieldLabel: getExaminationTranslation('DROOL_RULE_FOR_DESCRIPTION'),
				     allowBlank: false,
				     allowOnlyWhitespace: false
    		     }]
    	},{
        	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    	items:[{
			 xtype: 'textfield',
		     name:'entryCriteria',
		     itemId:'entryCriteriaItemId',
		     fieldLabel: getExaminationTranslation('ENTRY_CRITERIA')
	     },{
			 xtype: 'textarea',
		     name:'entryCriteriaDescription',
		     fieldLabel: getExaminationTranslation('ENTRY_CRITERIA_DESCRIPTION'),
		     allowBlank: true
	     }]
        },{
        	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    	items:[{
			 xtype: 'textfield',
		     name:'exitCriteria',
		     itemId:'exitCriteriaItemId',
		     fieldLabel: getExaminationTranslation('EXIT_CRITERIA')
	     },{
			 xtype: 'textarea',
		     name:'exitCriteriaDescription',
		     fieldLabel: getExaminationTranslation('EXIT_CRITERIA_DESCRIPTION'),
		     allowBlank: true
	     }]
        },{
        	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    	items:[{
			 xtype: 'numberfield',
		     name:'ageMin',
		     fieldLabel: getExaminationTranslation('AGE_MIN'),
		     minValue:1,
		     itemId:'ageMinItemId',
		     allowBlank: false,
			 validator : function(val) {
				var maxValuefield = Ext.ComponentQuery
				.query('numberfield#ageMaxItemId')[0];
				var maxValue = maxValuefield
				.getValue();
				if (maxValue != null) {
					if (val <= maxValue) {
						maxValuefield
						.clearInvalid();
						return true;
					} else {
						return getExaminationTranslation('LESS_THAN_MAX');
					}
				} else {
					return true;
				}
			}
	     },{
			 xtype: 'numberfield',
		     name:'ageMax',
		     fieldLabel: getExaminationTranslation('AGE_MAX'),
		     minValue:1,
		     itemId:'ageMaxItemId',
		     allowBlank: false,
			 validator : function(val) {
				var minValueField = Ext.ComponentQuery
				.query('numberfield#ageMinItemId')[0];
				var minValue = minValueField
				.getValue();
				if (minValue != null) {
					if (val >= minValue) {
						minValueField
						.clearInvalid();
						return true;
					} else {
						return getExaminationTranslation('MORE_THAN_MIN');
					}
				} else {
					return true;
				}
			}
	     }]
        },{
        	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    	items:[{
			 xtype: 'numberfield',
		     name:'maxAttempts',
		     fieldLabel: getExaminationTranslation('MAX_ATTEMPT'),
		     minValue:0,
		     allowBlank: false
	     }]
        },
        {
        	xtype: 'fieldcontainer',
            width:'100%',
            cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                action : 'Submit',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSave',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});