/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.studentcovered.StudentCoveredGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studentcoveredgrid',
    store: 'examinationcenters.evaluationgroup.studentcovered.StudentCoveredGridStore',
    border: true,
    frame: false,
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.evaluationgroup.studentcovered.StudentCoveredGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ID'),
        dataIndex: 'id',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    }, {
        header: getCommonTranslation('ADMISSION_CODE'),
        dataIndex: 'admissionCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_VARIANT_NAME'),
        dataIndex: 'courseVariantName',
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex: 1
    }, {
        header: getCommonTranslation('SECTION_NAME'),
        dataIndex: 'sectionName',
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_EVENT'),
        dataIndex: 'evaluationEvent',
        flex: 1
    }, {
        header: getCommonTranslation('CENTER_STATUS'),
        dataIndex: 'centerStatus',
        flex: 1
    }, {
        header: getCommonTranslation('APPLICATION_STATUS'),
        dataIndex: 'applicationStatus',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_STATUS'),
        dataIndex: 'studentStatus',
        flex: 1,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)) {
        		return value ? 'Active' : 'Inactive';
        	}
        	else {
        		return value;
        	}
        }
    }, {
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('SECTION_ID'),
        dataIndex: 'sectionId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('COURSE_VARIANT_ID'),
        dataIndex: 'courseVariantId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('EVENT_ID'),
        dataIndex: 'eventId',
        flex: 1,
        hidden: true
    }]
});